DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-10
      0.00000000000000E+00  -1.09275949882143E-11   0.00000000000000E+00  -1.13598892719110E-13   1.47974947624274E-22
      1.09276431119067E-08   1.09275295130142E-08  -7.99416023833534E-19  -2.46304709481801E-01  -2.46304709481827E-01
      0.00000000000000E+00   0.00000000000000E+00   2.57730110060833E-11   0.00000000000000E+00   2.57730110060833E-11
      3.71361512117044E-18  -2.46304709481801E-01  -2.42853835801530E-01   0.00000000000000E+00   1.25917339529291E-13
     -9.82500733686361E-23  -1.09534284413597E-08  -1.09533025240203E-08  -2.91419909733691E-18
      1.17500000000000E-09
      0.00000000000000E+00  -9.88047313931131E-12   0.00000000000000E+00  -7.70444282938508E-14   1.35419981016157E-22
      9.88050970492237E-09   9.88043266049421E-09  -8.08679659960903E-19  -2.42051569355066E-01  -2.42051569355093E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71332099231772E-11   0.00000000000000E+00   2.71332099231772E-11
      3.73193003786859E-18  -2.42051569355066E-01  -2.38930159062339E-01   0.00000000000000E+00   1.06144962777186E-13
     -9.81120347928389E-23  -9.90767201538006E-09  -9.90756587041738E-09  -2.92325037790768E-18
      2.08625000000000E-09
      0.00000000000000E+00  -8.88974395905372E-12   0.00000000000000E+00   4.41320561217210E-13   1.26249044426196E-22
      8.88982426944992E-09   8.89026559001126E-09  -8.18666931020313E-19  -2.37256267338132E-01  -2.37256267338159E-01
      0.00000000000000E+00   0.00000000000000E+00   2.66401452554676E-11   0.00000000000000E+00   2.66401452554676E-11
      3.75620587023263E-18  -2.37256267338104E-01  -2.34447122388647E-01   0.00000000000000E+00  -4.05059181635684E-13
     -9.79152091676405E-23  -8.91650067608499E-09  -8.91690573526673E-09  -2.93753893921232E-18
      3.31643750000000E-09
      0.00000000000000E+00  -7.97340901593423E-12   0.00000000000000E+00   5.00266738923285E-13   1.20341416393423E-22
      7.97342706507626E-09   7.97392733181530E-09  -8.29223136726318E-19  -2.31974899935389E-01  -2.31974899935413E-01
      0.00000000000000E+00   0.00000000000000E+00   2.45542838254020E-11   0.00000000000000E+00   2.45542838254020E-11
      3.78641224326609E-18  -2.31974899935373E-01  -2.29455119572061E-01   0.00000000000000E+00  -4.61883774908460E-13
     -9.76578583501234E-23  -7.99801973186570E-09  -7.99848161564070E-09  -2.95718910653977E-18
      4.97719062500000E-09
      0.00000000000000E+00  -7.14230598894332E-12   0.00000000000000E+00  -2.49511035191855E-14   1.17290148343880E-22
      7.14231600743822E-09   7.14229105633482E-09  -8.40153686401796E-19  -2.26319232763842E-01  -2.26319232763863E-01
      0.00000000000000E+00   0.00000000000000E+00   2.12451343442719E-11   0.00000000000000E+00   2.12451343442719E-11
      3.82169516651939E-18  -2.26319232763856E-01  -2.24062334577659E-01   0.00000000000000E+00   6.15801366113706E-14
     -9.73477249675590E-23  -7.16359777081561E-09  -7.16353619067909E-09  -2.98154148011759E-18
      7.21920734375000E-09
      0.00000000000000E+00  -6.40304769915994E-12   0.00000000000000E+00  -1.64646064840424E-14   1.16465683246812E-22
      6.40312369206720E-09   6.40310722746083E-09  -8.51180715035580E-19  -2.20472430859227E-01  -2.20472430859244E-01
      0.00000000000000E+00   0.00000000000000E+00   1.72031219377994E-11   0.00000000000000E+00   1.72031219377994E-11
      3.86026485351863E-18  -2.20472430859310E-01  -2.18449687330231E-01   0.00000000000000E+00   4.69251567247004E-14
     -9.70041774279792E-23  -6.42035727455525E-09  -6.42031034939863E-09  -3.00908413848305E-18
      1.02459299140625E-08
      0.00000000000000E+00  -5.76233881240023E-12   0.00000000000000E+00  -1.05893874777600E-14   1.17123520906428E-22
      5.76239269268420E-09   5.76238210329684E-09  -8.61914758791429E-19  -2.14693458931650E-01  -2.14693458931663E-01
      0.00000000000000E+00   0.00000000000000E+00   1.29705876850926E-11   0.00000000000000E+00   1.29705876850926E-11
      3.89952322401532E-18  -2.14693458931843E-01  -2.12873910579229E-01   0.00000000000000E+00   3.34141758320270E-14
     -9.66557934093937E-23  -5.77538610515767E-09  -5.77535269098194E-09  -3.03760846522388E-18
      1.43320053839844E-08
      0.00000000000000E+00  -5.22670030500593E-12   0.00000000000000E+00  -6.56829264234509E-15   1.18549438971555E-22
      5.22674035429262E-09   5.22673378600009E-09  -8.71856379051709E-19  -2.09300890690428E-01  -2.09300890690437E-01
      0.00000000000000E+00   0.00000000000000E+00   9.04462043615348E-12   0.00000000000000E+00   9.04462043615348E-12
      3.93648022571423E-18  -2.09300890690806E-01  -2.07651336410374E-01   0.00000000000000E+00   2.20094420909977E-14
     -9.63339682925121E-23  -5.23580041587824E-09  -5.23577840643625E-09  -3.06462384666252E-18
      1.93320053839844E-08
      0.00000000000000E+00  -4.82735938762761E-12   0.00000000000000E+00  -4.00831587299617E-15   1.20059619444436E-22
      4.82733869461330E-09   4.82733468629755E-09  -8.79920421745202E-19  -2.04918302155638E-01  -2.04918302155644E-01
      0.00000000000000E+00   0.00000000000000E+00   5.97971234208116E-12   0.00000000000000E+00   5.97971234208116E-12
      3.96637878742464E-18  -2.04918302156295E-01  -2.03395545166136E-01   0.00000000000000E+00   1.37876124139085E-14
     -9.60808874626274E-23  -4.83332818625195E-09  -4.83331439863964E-09  -3.08645836567944E-18
      2.43320053839844E-08
      0.00000000000000E+00  -4.57294946556276E-12   0.00000000000000E+00   1.49059959971485E-13   1.21194403216042E-22
      4.57300094099137E-09   4.57315000095146E-09  -8.85376491553169E-19  -2.01955532769666E-01  -2.01955532769670E-01
      0.00000000000000E+00   0.00000000000000E+00   4.00404024912029E-12   0.00000000000000E+00   4.00404024912029E-12
      3.98639898867024E-18  -2.01955532777229E-01  -2.00513527522428E-01   0.00000000000000E+00  -1.43418439905105E-13
     -9.59157946831074E-23  -4.57701062276058E-09  -4.57715404120058E-09  -3.10102249711707E-18
      2.93320053839844E-08
      0.00000000000000E+00  -4.40579204384506E-12   0.00000000000000E+00   6.20686938922600E-14   1.22002956616539E-22
      4.40579465283797E-09   4.40585672153199E-09  -8.89112976568959E-19  -1.99930064358241E-01  -1.99930064358244E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71006168824465E-12   0.00000000000000E+00   2.71006168824465E-12
      3.99994929711147E-18  -1.99930064367409E-01  -1.98541145367492E-01   0.00000000000000E+00  -5.82139151835896E-14
     -9.58073857048537E-23  -4.40850856930495E-09  -4.40856678322023E-09  -3.11083632054251E-18
      3.43320053839844E-08
      0.00000000000000E+00  -4.29355777497746E-12   0.00000000000000E+00  -1.12886649072086E-15   1.22565599966632E-22
      4.29354986172082E-09   4.29354873285445E-09  -8.91690044171793E-19  -1.98535543520444E-01  -1.98535543520446E-01
      0.00000000000000E+00   0.00000000000000E+00   1.84977695726963E-12   0.00000000000000E+00   1.84977695726963E-12
      4.00919818189782E-18  -1.98535543531987E-01  -1.97182258477014E-01   0.00000000000000E+00   3.85377655460347E-15
     -9.57349736120090E-23  -4.29540236358818E-09  -4.29539850981172E-09  -3.11750813772602E-18
      3.93320053839844E-08
      0.00000000000000E+00  -4.21714295362080E-12   0.00000000000000E+00   3.85782674131856E-14   1.22953876694832E-22
      4.21717922946542E-09   4.21721780773295E-09  -8.93474932878763E-19  -1.97571096201350E-01  -1.97571096201352E-01
      0.00000000000000E+00   0.00000000000000E+00   1.27065692987179E-12   0.00000000000000E+00   1.27065692987179E-12
      4.01555146654717E-18  -1.97571096216383E-01  -1.96242054294428E-01   0.00000000000000E+00  -3.68814093124762E-14
     -9.56856968679603E-23  -4.21845158325342E-09  -4.21848846466283E-09  -3.12207653366841E-18
      4.43320053839844E-08
      0.00000000000000E+00  -4.16469960867530E-12   0.00000000000000E+00   2.21654997548308E-13   1.23221206491262E-22
      4.16474185305416E-09   4.16496350805183E-09  -8.94714001388899E-19  -1.96902274708422E-01  -1.96902274708423E-01
      0.00000000000000E+00   0.00000000000000E+00   8.76906396033885E-13   0.00000000000000E+00   8.76906396033885E-13
      4.01993599852734E-18  -1.96902274725523E-01  -1.95589877282745E-01   0.00000000000000E+00  -2.21180203955782E-13
     -9.56513769588969E-23  -4.16561923424381E-09  -4.16584041444786E-09  -3.12522199713844E-18
      4.93320053839844E-08
      0.00000000000000E+00  -4.12878831642716E-12   0.00000000000000E+00   8.39343644097165E-15   1.23407839236033E-22
      4.12871174525216E-09   4.12872013868872E-09  -8.95577269492114E-19  -1.96436874052156E-01  -1.96436874052157E-01
      0.00000000000000E+00   0.00000000000000E+00   6.07277719270706E-13   0.00000000000000E+00   6.07277719270706E-13
      4.02297238712370E-18  -1.96436874069563E-01  -1.95135912993784E-01   0.00000000000000E+00  -7.56867767853608E-15
     -9.56293012523764E-23  -4.12931984773022E-09  -4.12932741640799E-09  -3.12739511763158E-18
      5.43320053839844E-08
      0.00000000000000E+00  -4.10362285843230E-12   0.00000000000000E+00   4.99528366769019E-14   1.23535513007502E-22
      4.10366242131417E-09   4.10371237415097E-09  -8.96178460315446E-19  -1.96112917099394E-01  -1.96112917099394E-01
      0.00000000000000E+00   0.00000000000000E+00   4.21718245809025E-13   0.00000000000000E+00   4.21718245809025E-13
      4.02508097835274E-18  -1.96112917114507E-01  -1.94819906322432E-01   0.00000000000000E+00  -4.95224090361815E-14
     -9.56132412159608E-23  -4.10408456998764E-09  -4.10413409239677E-09  -3.12890251803729E-18
      5.93320053839844E-08
      0.00000000000000E+00  -4.08626420310007E-12   0.00000000000000E+00  -1.74941950426680E-16   1.23624601468220E-22
      4.08630410338627E-09   4.08630392844444E-09  -8.96597884147739E-19  -1.95887045202297E-01  -1.95887045202297E-01
      0.00000000000000E+00   0.00000000000000E+00   2.93325417860354E-13   0.00000000000000E+00   2.93325417860354E-13
      4.02654760544204E-18  -1.95887045211835E-01  -1.94599543657158E-01   0.00000000000000E+00   5.81680696405291E-16
     -9.56024608491494E-23  -4.08659783554290E-09  -4.08659725386230E-09  -3.12994972129430E-18
      6.43320053839844E-08
      0.00000000000000E+00  -4.07423254252589E-12   0.00000000000000E+00   1.16296706085445E-14   1.23686195875032E-22
      4.07420549882621E-09   4.07421712849694E-09  -8.96890420832364E-19  -1.95729541207945E-01  -1.95729541207945E-01
      0.00000000000000E+00   0.00000000000000E+00   2.04308811085999E-13   0.00000000000000E+00   2.04308811085999E-13
      4.02756914949747E-18  -1.95729541207719E-01  -1.94445879382704E-01   0.00000000000000E+00  -1.13820235470526E-14
     -9.55947693523049E-23  -4.07441005528438E-09  -4.07442143730803E-09  -3.13067872866511E-18
      6.93320053839844E-08
      0.00000000000000E+00  -4.06578282670279E-12   0.00000000000000E+00   3.95176713470149E-16   1.23729190975091E-22
      4.06578772783793E-09   4.06578812301477E-09  -8.97094639617434E-19  -1.95619621909725E-01  -1.95619621909725E-01
      0.00000000000000E+00   0.00000000000000E+00   1.42412397271122E-13   0.00000000000000E+00   1.42412397271122E-13
      4.02828121148383E-18  -1.95619621895553E-01  -1.94338631609697E-01   0.00000000000000E+00  -2.00262194319785E-16
     -9.55895067458786E-23  -4.06593033514975E-09  -4.06593053541204E-09  -3.13118657186640E-18
      7.43320053839844E-08
      0.00000000000000E+00  -4.05990476352151E-12   0.00000000000000E+00   2.71609446167412E-15   1.23759074949480E-22
      4.05991435886448E-09   4.05991707495907E-09  -8.97237188341443E-19  -1.95542905158954E-01  -1.95542905158954E-01
      0.00000000000000E+00   0.00000000000000E+00   9.93378352026283E-14   0.00000000000000E+00   9.93378352026283E-14
      4.02877790065984E-18  -1.95542905127023E-01  -1.94263778827456E-01   0.00000000000000E+00  -2.58737171785884E-15
     -9.55857949811757E-23  -4.06001382542246E-09  -4.06001641279427E-09  -3.13154071231840E-18
      7.93320053839844E-08
      0.00000000000000E+00  -4.05586359508438E-12   0.00000000000000E+00   7.23564077969163E-17   1.23779936504632E-22
      4.05581941675020E-09   4.05581948910673E-09  -8.97336731310754E-19  -1.95489341242462E-01  -1.95489341242462E-01
      0.00000000000000E+00   0.00000000000000E+00   6.93172743917516E-14   0.00000000000000E+00   6.93172743917516E-14
      4.02912448703180E-18  -1.95489341189711E-01  -1.94211514468509E-01   0.00000000000000E+00   2.25936910163183E-17
     -9.55832265589051E-23  -4.05588882897472E-09  -4.05588880638113E-09  -3.13178775572105E-18
      8.43320053839844E-08
      0.00000000000000E+00  -4.05292456349374E-12   0.00000000000000E+00   6.29201246708113E-16   1.23794473102306E-22
      4.05296060611885E-09   4.05296123532022E-09  -8.97406239231506E-19  -1.95451941313632E-01  -1.95451941313632E-01
      0.00000000000000E+00   0.00000000000000E+00   4.83858319848175E-14   0.00000000000000E+00   4.83858319848175E-14
      4.02936641619172E-18  -1.95451941238152E-01  -1.94175021785139E-01   0.00000000000000E+00  -5.64619170021298E-16
     -9.55814240717683E-23  -4.05300905653294E-09  -4.05300962115220E-09  -3.13196017696022E-18
      8.93320053839844E-08
      0.00000000000000E+00  -4.05099582401238E-12   0.00000000000000E+00   6.85322663610997E-18   1.23804623692645E-22
      4.05096551935963E-09   4.05096552621298E-09  -8.97454784338047E-19  -1.95425822708945E-01  -1.95425822708946E-01
      0.00000000000000E+00   0.00000000000000E+00   3.37809971784043E-14   0.00000000000000E+00   3.37809971784043E-14
      4.02953532117762E-18  -1.95425822611393E-01  -1.94149536315846E-01   0.00000000000000E+00   3.94382583552265E-17
     -9.55801707465747E-23  -4.05099934664832E-09  -4.05099930721016E-09  -3.13208053683957E-18
      9.43320053839844E-08
      0.00000000000000E+00  -4.04952630821706E-12   0.00000000000000E+00   1.42322454753444E-16   1.23811705486506E-22
      4.04957229985252E-09   4.04957244217510E-09  -8.97488687874980E-19  -1.95407582193511E-01  -1.95407582193511E-01
      0.00000000000000E+00   0.00000000000000E+00   2.35884897359305E-14   0.00000000000000E+00   2.35884897359305E-14
      4.02965326362630E-18  -1.95407582077844E-01  -1.94131737929959E-01   0.00000000000000E+00  -1.10397096986657E-16
     -9.55792932894826E-23  -4.04959592026764E-09  -4.04959603066484E-09  -3.13216457575132E-18
      9.93320053839844E-08
      0.00000000000000E+00  -4.04860786084499E-12   0.00000000000000E+00   1.27916255832500E-16   1.23816653744730E-22
      4.04859951976781E-09   4.04859964768419E-09  -8.97512367764577E-19  -1.95394842525541E-01  -1.95394842525541E-01
      0.00000000000000E+00   0.00000000000000E+00   1.64727263889693E-14   0.00000000000000E+00   1.64727263889693E-14
      4.02973562725824E-18  -1.95394842399263E-01  -1.94119306969526E-01   0.00000000000000E+00  -1.06043242225944E-16
     -9.55786817592204E-23  -4.04861601436724E-09  -4.04861612041058E-09  -3.13222325949366E-18
      1.04332005383984E-07
      0.00000000000000E+00  -4.04796494768453E-12   0.00000000000000E+00   3.02735528152658E-17   1.23820104515251E-22
      4.04792018486663E-09   4.04792021514030E-09  -8.97528907502732E-19  -1.95385944420010E-01  -1.95385944420010E-01
      0.00000000000000E+00   0.00000000000000E+00   1.15044634373008E-14   0.00000000000000E+00   1.15044634373008E-14
      4.02979314957543E-18  -1.95385944295349E-01  -1.94110624456730E-01   0.00000000000000E+00  -1.48194380899863E-17
     -9.55782540866331E-23  -4.04793170478421E-09  -4.04793171960375E-09  -3.13226424207269E-18
      1.09332005383984E-07
      0.00000000000000E+00  -4.04750572399850E-12   0.00000000000000E+00   2.79814977773022E-17   1.23822516197920E-22
      4.04744571682302E-09   4.04744574480464E-09  -8.97540460170693E-19  -1.95379729372566E-01  -1.95379729372566E-01
      0.00000000000000E+00   0.00000000000000E+00   8.03501679817255E-15   0.00000000000000E+00   8.03501679817255E-15
      4.02983332465942E-18  -1.95379729266336E-01  -1.94104560002802E-01   0.00000000000000E+00  -1.71313572919057E-17
     -9.55779557021911E-23  -4.04745376268999E-09  -4.04745377982144E-09  -3.13229286448872E-18
      1.14332005383984E-07
      0.00000000000000E+00  -4.04713834504967E-12   0.00000000000000E+00   1.86442106197013E-16   1.23824202931175E-22
      4.04711428635803E-09   4.04711447280026E-09  -8.97548529027228E-19  -1.95375388485967E-01  -1.95375388485967E-01
      0.00000000000000E+00   0.00000000000000E+00   5.61211284652190E-15   0.00000000000000E+00   5.61211284652190E-15
      4.02986138522365E-18  -1.95375388419859E-01  -1.94100324337491E-01   0.00000000000000E+00  -1.79795473084167E-16
     -9.55777471842770E-23  -4.04711990511754E-09  -4.04712008491311E-09  -3.13231285619642E-18
      1.19332005383984E-07
      0.00000000000000E+00  -4.04686281083804E-12   0.00000000000000E+00   5.38624948661036E-18   1.23825376517730E-22
      4.04688289285302E-09   4.04688289823939E-09  -8.97554165746911E-19  -1.95372356158456E-01  -1.95372356158456E-01
      0.00000000000000E+00   0.00000000000000E+00   3.91989104163196E-15   0.00000000000000E+00   3.91989104163196E-15
      4.02988098467886E-18  -1.95372356157739E-01  -1.94097365509574E-01   0.00000000000000E+00  -3.52876269858324E-19
     -9.55776015686893E-23  -4.04688681777746E-09  -4.04688681813044E-09  -3.13232681893195E-18
      1.24332005383984E-07
      0.00000000000000E+00  -4.04667912136363E-12   0.00000000000000E+00   4.35390368272059E-17   1.23826198093274E-22
      4.04672120360418E-09   4.04672124714334E-09  -8.97558102865686E-19  -1.95370238137148E-01  -1.95370238137148E-01
      0.00000000000000E+00   0.00000000000000E+00   2.73801173116535E-15   0.00000000000000E+00   2.73801173116535E-15
      4.02989467473752E-18  -1.95370238228657E-01  -1.94095298893271E-01   0.00000000000000E+00  -4.00396305337027E-17
     -9.55774998595546E-23  -4.04672394511534E-09  -4.04672398515507E-09  -3.13233657187183E-18
      1.29332005383984E-07
      0.00000000000000E+00  -4.04658727662642E-12   0.00000000000000E+00   6.98741147315456E-19   1.23826771094272E-22
      4.04660829082073E-09   4.04660829151960E-09  -8.97560853107397E-19  -1.95368758626859E-01  -1.95368758626859E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91253704517279E-15   0.00000000000000E+00   1.91253704517279E-15
      4.02990423742274E-18  -1.95368758836556E-01  -1.94093855334650E-01   0.00000000000000E+00   1.84489920118675E-18
     -9.55774288249911E-23  -4.04661020590145E-09  -4.04661020405664E-09  -3.13234338431534E-18
      1.34332005383984E-07
      0.00000000000000E+00  -4.04649543188921E-12   0.00000000000000E+00   9.95328669630647E-18   1.23827171837480E-22
      4.04652940597681E-09   4.04652941593022E-09  -8.97562774152910E-19  -1.95367725180899E-01  -1.95367725180899E-01
      0.00000000000000E+00   0.00000000000000E+00   1.33595228283090E-15   0.00000000000000E+00   1.33595228283090E-15
      4.02991091718416E-18  -1.95367725529965E-01  -1.94092847062517E-01   0.00000000000000E+00  -8.18329486144883E-18
     -9.55773792118258E-23  -4.04653074369911E-09  -4.04653075188250E-09  -3.13234814303125E-18
      1.39332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.23049822337150E-19   1.23827451583280E-22
      4.04647431089000E-09   4.04647431076707E-09  -8.97564116064242E-19  -1.95367003287109E-01  -1.95367003287109E-01
      0.00000000000000E+00   0.00000000000000E+00   9.33207795318644E-16   0.00000000000000E+00   9.33207795318644E-16
      4.02991558322313E-18  -1.95367003787280E-01  -1.94092142804539E-01   0.00000000000000E+00   1.37935509055331E-18
     -9.55773445622129E-23  -4.04647524535412E-09  -4.04647524397486E-09  -3.13235146715889E-18
      1.44332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   2.17011899142618E-18   1.23827647132689E-22
      4.04643582341396E-09   4.04643582558420E-09  -8.97565053395563E-19  -1.95366499037114E-01  -1.95366499037114E-01
      0.00000000000000E+00   0.00000000000000E+00   6.51876653229507E-16   0.00000000000000E+00   6.51876653229507E-16
      4.02991884260640E-18  -1.95366499685116E-01  -1.94091650916557E-01   0.00000000000000E+00  -1.29096125264560E-18
     -9.55773203632732E-23  -4.04643647616980E-09  -4.04643647746085E-09  -3.13235378921083E-18
      1.49332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.68612213961768E-19   1.23827783718348E-22
      4.04640894251721E-09   4.04640894234872E-09  -8.97565708113229E-19  -1.95366146820862E-01  -1.95366146820862E-01
      0.00000000000000E+00   0.00000000000000E+00   4.55342964122017E-16   0.00000000000000E+00   4.55342964122017E-16
      4.02992111932122E-18  -1.95366147592629E-01  -1.94091307354869E-01   0.00000000000000E+00   7.85841981133789E-19
     -9.55773034622563E-23  -4.04640939847743E-09  -4.04640939769169E-09  -3.13235541120799E-18
      1.54332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   4.23776603712430E-19   1.23827879203309E-22
      4.04639016779079E-09   4.04639016821469E-09  -8.97566165378369E-19  -1.95365900824268E-01  -1.95365900824268E-01
      0.00000000000000E+00   0.00000000000000E+00   3.18030253271293E-16   0.00000000000000E+00   3.18030253271293E-16
      4.02992270947248E-18  -1.95365901669497E-01  -1.94091067390009E-01   0.00000000000000E+00   1.13307027379407E-20
     -9.55772916562681E-23  -4.04639048625618E-09  -4.04639048624495E-09  -3.13235654409412E-18
      1.59332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.07071986089871E-19   1.23827945953331E-22
      4.04637705819282E-09   4.04637705808587E-09  -8.97566484678419E-19  -1.95365729046559E-01  -1.95365729046559E-01
      0.00000000000000E+00   0.00000000000000E+00   2.22073399653334E-16   0.00000000000000E+00   2.22073399653334E-16
      4.02992381983948E-18  -1.95365729884480E-01  -1.94090899765429E-01   0.00000000000000E+00   4.10761978039140E-19
     -9.55772834051380E-23  -4.04637728056994E-09  -4.04637728015927E-09  -3.13235733516106E-18
      1.64332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   5.04152718949953E-20   1.23827992659101E-22
      4.04636790694099E-09   4.04636790699153E-09  -8.97566707555575E-19  -1.95365609140196E-01  -1.95365609140196E-01
      0.00000000000000E+00   0.00000000000000E+00   1.54996043366639E-16   0.00000000000000E+00   1.54996043366639E-16
      4.02992459481970E-18  -1.95365609857572E-01  -1.94090782642774E-01   0.00000000000000E+00   1.60455497924125E-19
     -9.55772776324301E-23  -4.04636806214793E-09  -4.04636806198757E-09  -3.13235788726412E-18
      1.69332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -5.87690476082112E-20   1.23828025360584E-22
      4.04636152273952E-09   4.04636152268088E-09  -8.97566863027625E-19  -1.95365525495838E-01  -1.95365525495838E-01
      0.00000000000000E+00   0.00000000000000E+00   1.08085881166466E-16   0.00000000000000E+00   1.08085881166466E-16
      4.02992513524911E-18  -1.95365525948437E-01  -1.94090700759773E-01   0.00000000000000E+00   2.09077572492908E-19
     -9.55772735851665E-23  -4.04636163097574E-09  -4.04636163076676E-09  -3.13235827222148E-18
      1.74332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.07171201750194E-20   1.23828048281370E-22
      4.04635707271792E-09   4.04635707270733E-09  -8.97566971368679E-19  -1.95365467208037E-01  -1.95365467208037E-01
      0.00000000000000E+00   0.00000000000000E+00   7.52634600038190E-17   0.00000000000000E+00   7.52634600038190E-17
      4.02992551156641E-18  -1.95365467226789E-01  -1.94090643450454E-01   0.00000000000000E+00   1.15838626970239E-19
     -9.55772707372838E-23  -4.04635714808653E-09  -4.04635714797079E-09  -3.13235854019772E-18
      1.79332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -2.91099661818744E-20   1.23828064354922E-22
      4.04635397473366E-09   4.04635397470468E-09  -8.97567046754282E-19  -1.95365426652389E-01  -1.95365426652389E-01
      0.00000000000000E+00   0.00000000000000E+00   5.22891986492609E-17   0.00000000000000E+00   5.22891986492609E-17
      4.02992577301240E-18  -1.95365426055360E-01  -1.94090603262288E-01   0.00000000000000E+00   1.04701783402699E-19
     -9.55772687214078E-23  -4.04635402709848E-09  -4.04635402699388E-09  -3.13235872625812E-18
      1.84332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.43144879880336E-20   1.23828075619170E-22
      4.04635182105729E-09   4.04635182104310E-09  -8.97567099110585E-19  -1.95365398490633E-01  -1.95365398490633E-01
      0.00000000000000E+00   0.00000000000000E+00   3.62117064153558E-17   0.00000000000000E+00   3.62117064153558E-17
      4.02992595407093E-18  -1.95365397101650E-01  -1.94090574992164E-01   0.00000000000000E+00   6.75868965713266E-20
     -9.55772672822230E-23  -4.04635185732229E-09  -4.04635185725480E-09  -3.13235885496035E-18
      1.89332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.49815647088251E-20   1.23828083480383E-22
      4.04635032556471E-09   4.04635032554986E-09  -8.97567135406460E-19  -1.95365378975387E-01  -1.95365378975387E-01
      0.00000000000000E+00   0.00000000000000E+00   2.49803274558348E-17   0.00000000000000E+00   2.49803274558348E-17
      4.02992607897257E-18  -1.95365376649608E-01  -1.94090555014818E-01   0.00000000000000E+00   5.52873551964035E-20
     -9.55772662434965E-23  -4.04635035058538E-09  -4.04635035053019E-09  -3.13235894356611E-18
      1.94332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -8.47905262993750E-21   1.23828088904388E-22
      4.04634928660449E-09   4.04634928659614E-09  -8.97567160556800E-19  -1.95365365464022E-01  -1.95365365464022E-01
      0.00000000000000E+00   0.00000000000000E+00   1.71749343178936E-17   0.00000000000000E+00   1.71749343178936E-17
      4.02992616484724E-18  -1.95365362119963E-01  -1.94090540814958E-01   0.00000000000000E+00   3.70508767279383E-20
     -9.55772654856487E-23  -4.04634930380803E-09  -4.04634930377107E-09  -3.13235900429044E-18
      1.99332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -8.23078487161687E-21   1.23828092549519E-22
      4.04634856127117E-09   4.04634856126306E-09  -8.97567178051307E-19  -1.95365356080102E-01  -1.95365356080102E-01
      0.00000000000000E+00   0.00000000000000E+00   1.18150747340449E-17   0.00000000000000E+00   1.18150747340449E-17
      4.02992622392261E-18  -1.95365351736576E-01  -1.94090530661777E-01   0.00000000000000E+00   2.85791395383933E-20
     -9.55772649298119E-23  -4.04634857310662E-09  -4.04634857307814E-09  -3.13235904587131E-18
      2.04332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -5.63974732759661E-21   1.23828094862982E-22
      4.04634804749766E-09   4.04634804749215E-09  -8.97567190390868E-19  -1.95365349478342E-01  -1.95365349478342E-01
      0.00000000000000E+00   0.00000000000000E+00   8.22558474994642E-18   0.00000000000000E+00   8.22558474994642E-18
      4.02992626505054E-18  -1.95365344293479E-01  -1.94090523381676E-01   0.00000000000000E+00   2.12595842106678E-20
     -9.55772645268287E-23  -4.04634805573890E-09  -4.04634805571773E-09  -3.13235907465967E-18
      2.09332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -3.80585786420058E-21   1.23828096150899E-22
      4.04634767183034E-09   4.04634767182666E-09  -8.97567199386274E-19  -1.95365344683534E-01  -1.95365344683534E-01
      0.00000000000000E+00   0.00000000000000E+00   5.94015866557154E-18   0.00000000000000E+00   5.94015866557154E-18
      4.02992629475133E-18  -1.95365338991616E-01  -1.94090518198888E-01   0.00000000000000E+00   1.38943073804891E-20
     -9.55772642491357E-23  -4.04634767778062E-09  -4.04634767776682E-09  -3.13235909536506E-18
      2.14332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -3.04368041830649E-21   1.23828096630810E-22
      4.04634738116700E-09   4.04634738116408E-09  -8.97567206359116E-19  -1.95365340982167E-01  -1.95365340982167E-01
      0.00000000000000E+00   0.00000000000000E+00   4.63184499308145E-18   0.00000000000000E+00   4.63184499308145E-18
      4.02992631791055E-18  -1.95365335322509E-01  -1.94090514621767E-01   0.00000000000000E+00   8.25547448294158E-21
     -9.55772640846609E-23  -4.04634738580408E-09  -4.04634738579592E-09  -3.13235911155144E-18
      2.19332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.83023174319977E-21   1.23828096472001E-22
      4.04634713739030E-09   4.04634713738860E-09  -8.97567212271390E-19  -1.95365337852402E-01  -1.95365337852402E-01
      0.00000000000000E+00   0.00000000000000E+00   4.06170862036972E-18   0.00000000000000E+00   4.06170862036972E-18
      4.02992633821910E-18  -1.95365332983210E-01  -1.94090512359450E-01   0.00000000000000E+00   3.91330339496549E-21
     -9.55772640317078E-23  -4.04634714145413E-09  -4.04634714145031E-09  -3.13235912594771E-18
      2.24332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.18007197831592E-21   1.23828095826976E-22
      4.04634691407185E-09   4.04634691407079E-09  -8.97567217803713E-19  -1.95365334921852E-01  -1.95365334921852E-01
      0.00000000000000E+00   0.00000000000000E+00   4.04066431794767E-18   0.00000000000000E+00   4.04066431794767E-18
      4.02992635842242E-18  -1.95365331810988E-01  -1.94090511257592E-01   0.00000000000000E+00  -9.97185968503299E-22
     -9.55772640943774E-23  -4.04634691811036E-09  -4.04634691811146E-09  -3.13235914061870E-18
      2.29332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.61534068166995E-21   1.23828094855986E-22
      4.04634669464581E-09   4.04634669464432E-09  -8.97567223396199E-19  -1.95365331945602E-01  -1.95365331945602E-01
      0.00000000000000E+00   0.00000000000000E+00   4.40082784027900E-18   0.00000000000000E+00   4.40082784027900E-18
      4.02992638042656E-18  -1.95365331729963E-01  -1.94090511245586E-01   0.00000000000000E+00  -7.08317516004269E-21
     -9.55772642780138E-23  -4.04634669903796E-09  -4.04634669904514E-09  -3.13235915703036E-18
      2.34332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -3.10631887666732E-21   1.23828093745107E-22
      4.04634647158679E-09   4.04634647158380E-09  -8.97567229263537E-19  -1.95365328798394E-01  -1.95365328798394E-01
      0.00000000000000E+00   0.00000000000000E+00   4.97463061117328E-18   0.00000000000000E+00   4.97463061117328E-18
      4.02992640529971E-18  -1.95365332704206E-01  -1.94090512289925E-01   0.00000000000000E+00  -1.06366503307019E-20
     -9.55772645845841E-23  -4.04634647654770E-09  -4.04634647655844E-09  -3.13235917603617E-18
      2.39332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -2.46118847705331E-21   1.23828092717582E-22
      4.04634624619207E-09   4.04634624618973E-09  -8.97567235393942E-19  -1.95365325475802E-01  -1.95365325475802E-01
      0.00000000000000E+00   0.00000000000000E+00   5.58084344390626E-18   0.00000000000000E+00   5.58084344390626E-18
      4.02992643320393E-18  -1.95365334694212E-01  -1.94090514350753E-01   0.00000000000000E+00  -1.87133537390516E-20
     -9.55772650078929E-23  -4.04634625175176E-09  -4.04634625177057E-09  -3.13235919780998E-18
      2.44332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -9.87584452988137E-22   1.23828092037387E-22
      4.04634602861488E-09   4.04634602861401E-09  -8.97567241541133E-19  -1.95365322099555E-01  -1.95365322099555E-01
      0.00000000000000E+00   0.00000000000000E+00   6.01748678943836E-18   0.00000000000000E+00   6.01748678943836E-18
      4.02992646329136E-18  -1.95365337615320E-01  -1.94090517340272E-01   0.00000000000000E+00  -2.14305826298426E-20
     -9.55772655288600E-23  -4.04634603460997E-09  -4.04634603463150E-09  -3.13235922175023E-18
      2.49332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.80554213187507E-21   1.23828092003533E-22
      4.04634583777075E-09   4.04634583776906E-09  -8.97567247218599E-19  -1.95365318922033E-01  -1.95365318922033E-01
      0.00000000000000E+00   0.00000000000000E+00   6.06227704034720E-18   0.00000000000000E+00   6.06227704034720E-18
      4.02992649360275E-18  -1.95365341298582E-01  -1.94090521083649E-01   0.00000000000000E+00  -2.30911875989411E-20
     -9.55772661111749E-23  -4.04634584380815E-09  -4.04634584383134E-09  -3.13235924638415E-18
      2.54332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -7.02282277680453E-22   1.23828092933882E-22
      4.04634570078242E-09   4.04634570078184E-09  -8.97567251705189E-19  -1.95365316325081E-01  -1.95365316325081E-01
      0.00000000000000E+00   0.00000000000000E+00   5.48101775302183E-18   0.00000000000000E+00   5.48101775302183E-18
      4.02992652100784E-18  -1.95365345456013E-01  -1.94090525284423E-01   0.00000000000000E+00  -2.82499447207306E-20
     -9.55772666978911E-23  -4.04634570623451E-09  -4.04634570626286E-09  -3.13235926930265E-18
      2.59332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -9.63809271712497E-22   1.23828095140797E-22
      4.04634565183859E-09   4.04634565183775E-09  -8.97567254066919E-19  -1.95365314810267E-01  -1.95365314810267E-01
      0.00000000000000E+00   0.00000000000000E+00   4.04161890858612E-18   0.00000000000000E+00   4.04161890858612E-18
      4.02992654121593E-18  -1.95365349652919E-01  -1.94090529497203E-01   0.00000000000000E+00  -2.27848535325050E-20
     -9.55772672093517E-23  -4.04634565585648E-09  -4.04634565587936E-09  -3.13235928714901E-18
      2.64332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -5.43171449143475E-22   1.23828098840638E-22
      4.04634572720630E-09   4.04634572720588E-09  -8.97567253274255E-19  -1.95365314940225E-01  -1.95365314940225E-01
      0.00000000000000E+00   0.00000000000000E+00   1.58615416903058E-18   0.00000000000000E+00   1.58615416903058E-18
      4.02992654914670E-18  -1.95365353304709E-01  -1.94090533126024E-01   0.00000000000000E+00  -1.53240187621993E-20
     -9.55772675473761E-23  -4.04634572877661E-09  -4.04634572879203E-09  -3.13235929587245E-18
      2.69332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.57057018646782E-19   1.23828104208042E-22
      4.04634596536429E-09   4.04634596520736E-09  -8.97567248200061E-19  -1.95365317338127E-01  -1.95365317338127E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.04000670192522E-18   0.00000000000000E+00  -2.04000670192522E-18
      4.02992653894667E-18  -1.95365355673572E-01  -1.94090535420993E-01   0.00000000000000E+00   2.14219412658789E-19
     -9.55772675828968E-23  -4.04634596338147E-09  -4.04634596316735E-09  -3.13235929074661E-18
      2.74332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   2.45269616518766E-18   1.23828110997329E-22
      4.04634638051454E-09   4.04634638296736E-09  -8.97567238141444E-19  -1.95365322417796E-01  -1.95365322417796E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.57310058536852E-18   0.00000000000000E+00  -6.57310058536852E-18
      4.02992650608116E-18  -1.95365355988609E-01  -1.94090535606660E-01   0.00000000000000E+00  -2.23531785392438E-18
     -9.55772670544662E-23  -4.04634637415885E-09  -4.04634637639426E-09  -3.13235926793972E-18
      2.76832005383985E-07
      0.00000000000000E+00  -4.04658727662642E-12   0.00000000000000E+00   1.60069730278422E-13   1.23837018628911E-22
      4.04650498451443E-09   4.04666505424483E-09  -8.97565690089595E-19  -1.95366036249978E-01  -1.95366036249978E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.91666659213569E-15   0.00000000000000E+00  -1.91666659213569E-15
      4.02992171441469E-18  -1.95364975797737E-01  -1.94090106071603E-01   0.00000000000000E+00  -1.60273089018190E-13
     -9.30833931810771E-23  -4.04650286448912E-09  -4.04666313757824E-09  -3.13235602432509E-18
      2.77675755383985E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -6.04222731268138E-18   1.23830041710010E-22
      4.04640175698477E-09   4.04640175094267E-09  -8.97565804003353E-19  -1.95366005887067E-01  -1.95366005887067E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.26346385707454E-16   0.00000000000000E+00  -3.26346385707454E-16
      4.02992143905992E-18  -1.95364933486075E-01  -1.94090095760641E-01   0.00000000000000E+00   2.74255083049460E-18
     -9.55764665884221E-23  -4.04640142733874E-09  -4.04640142459629E-09  -3.13235563505657E-18
      2.78814817883985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -9.78608864841558E-18   1.23835042828383E-22
      4.04639426675938E-09   4.04639425697341E-09  -8.97565940330400E-19  -1.95365971379969E-01  -1.95365971379969E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.66971933269878E-16   0.00000000000000E+00  -1.66971933269878E-16
      4.02992124886845E-18  -1.95364885138011E-01  -1.94090049719681E-01   0.00000000000000E+00   9.74659852953177E-18
     -9.57284918708303E-23  -4.04639409974798E-09  -4.04639409000148E-09  -3.13235530853805E-18
      2.80352552258985E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -2.08283847210321E-19   1.23828696428866E-22
      4.04638773053946E-09   4.04638773033130E-09  -8.97566069157579E-19  -1.95365934237298E-01  -1.95365934237298E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.14303521762939E-17   0.00000000000000E+00  -5.14303521762939E-17
      4.02992116978224E-18  -1.95364830469864E-01  -1.94089997074383E-01   0.00000000000000E+00   2.84102443083313E-19
     -9.55828796195347E-23  -4.04638767918496E-09  -4.04638767890095E-09  -3.13235510062465E-18
      2.82428493665235E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.31128354605598E-19   1.23828320159351E-22
      4.04638218228687E-09   4.04638218215586E-09  -8.97566184809122E-19  -1.95365894717489E-01  -1.95365894717489E-01
      0.00000000000000E+00   0.00000000000000E+00   1.36859176269961E-17   0.00000000000000E+00   1.36859176269961E-17
      4.02992119819340E-18  -1.95364769179594E-01  -1.94089937511545E-01   0.00000000000000E+00   3.82344235404406E-19
     -9.55791465512102E-23  -4.04638219622403E-09  -4.04638219584178E-09  -3.13235501338428E-18
      2.85231014563672E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -8.86503355364703E-20   1.23828101836672E-22
      4.04637711892150E-09   4.04637711883298E-09  -8.97566294910624E-19  -1.95365849879490E-01  -1.95365849879490E-01
      0.00000000000000E+00   0.00000000000000E+00   4.84913340006598E-17   0.00000000000000E+00   4.84913340006598E-17
      4.02992133409138E-18  -1.95364702229395E-01  -1.94089872145594E-01   0.00000000000000E+00   3.35605429521669E-19
     -9.55771675802726E-23  -4.04637716765982E-09  -4.04637716732431E-09  -3.13235503918076E-18
      2.89014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -7.84137483522336E-20   1.23827974232812E-22
      4.04637117040414E-09   4.04637117032585E-09  -8.97566430223366E-19  -1.95365786521220E-01  -1.95365786521220E-01
      0.00000000000000E+00   0.00000000000000E+00   8.22094995691285E-17   0.00000000000000E+00   8.22094995691285E-17
      4.02992164512306E-18  -1.95364636470675E-01  -1.94089808250350E-01   0.00000000000000E+00   1.87173315097650E-19
     -9.55771650578142E-23  -4.04637125272243E-09  -4.04637125253535E-09  -3.13235521489969E-18
      2.94014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -9.88690913347503E-20   1.23827837662837E-22
      4.04636131167925E-09   4.04636131158050E-09  -8.97566667201544E-19  -1.95365667058409E-01  -1.95365667058409E-01
      0.00000000000000E+00   0.00000000000000E+00   1.52669285571395E-16   0.00000000000000E+00   1.52669285571395E-16
      4.02992240846949E-18  -1.95364599904575E-01  -1.94089774768108E-01   0.00000000000000E+00  -1.40806682244882E-19
     -9.55771695729355E-23  -4.04636146410889E-09  -4.04636146424979E-09  -3.13235574126795E-18
      2.99014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.33550222590542E-19   1.23827674396533E-22
      4.04634753533937E-09   4.04634753520594E-09  -8.97567012795295E-19  -1.95365487930365E-01  -1.95365487930365E-01
      0.00000000000000E+00   0.00000000000000E+00   2.59066328265996E-16   0.00000000000000E+00   2.59066328265996E-16
      4.02992370380113E-18  -1.95364629651496E-01  -1.94089808821862E-01   0.00000000000000E+00  -6.06705591737354E-19
     -9.55771852638193E-23  -4.04634779366547E-09  -4.04634779427228E-09  -3.13235669100584E-18
      3.04014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.78988708943511E-19   1.23827474846877E-22
      4.04632877330696E-09   4.04632877312809E-09  -8.97567499219076E-19  -1.95365231863097E-01  -1.95365231863097E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98261601345061E-16   0.00000000000000E+00   3.98261601345061E-16
      4.02992569510914E-18  -1.95364745969238E-01  -1.94089931006911E-01   0.00000000000000E+00  -1.20621324734351E-18
     -9.55772152044931E-23  -4.04632917018339E-09  -4.04632917138969E-09  -3.13235819589006E-18
      3.09014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -2.32375421282937E-19   1.23827249912883E-22
      4.04630472010561E-09   4.04630471987336E-09  -8.97568140439168E-19  -1.95364890212848E-01  -1.95364890212848E-01
      0.00000000000000E+00   0.00000000000000E+00   5.59698701813163E-16   0.00000000000000E+00   5.59698701813163E-16
      4.02992849360264E-18  -1.95364969633423E-01  -1.94090162198447E-01   0.00000000000000E+00  -1.91377818741740E-18
     -9.55772619564721E-23  -4.04630527765819E-09  -4.04630527957207E-09  -3.13236035316348E-18
      3.14014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -2.05500779355997E-19   1.23827023272014E-22
      4.04627595747176E-09   4.04627595726639E-09  -8.97568927835157E-19  -1.95364465943209E-01  -1.95364465943209E-01
      0.00000000000000E+00   0.00000000000000E+00   7.26176273169574E-16   0.00000000000000E+00   7.26176273169574E-16
      4.02993212448401E-18  -1.95365317754601E-01  -1.94090519329163E-01   0.00000000000000E+00  -2.76018698563586E-18
     -9.55773268816307E-23  -4.04627668068238E-09  -4.04627668344266E-09  -3.13236319664886E-18
      3.19014417776563E-07
      0.00000000000000E+00  -4.04621989767759E-12   0.00000000000000E+00  -3.09262528668260E-19   1.23826829266316E-22
      4.04624413007808E-09   4.04624412976894E-09  -8.97569824677304E-19  -1.95363976896811E-01  -1.95363976896811E-01
      0.00000000000000E+00   0.00000000000000E+00   8.73766060352160E-16   0.00000000000000E+00   8.73766060352160E-16
      4.02993649331431E-18  -1.95365798964291E-01  -1.94091010519947E-01   0.00000000000000E+00  -3.44114292571206E-18
     -9.55774094374500E-23  -4.04624500009376E-09  -4.04624500353500E-09  -3.13236666863701E-18
      3.24014417776563E-07
      0.00000000000000E+00  -4.04621989767759E-12   0.00000000000000E+00  -2.71678996436742E-19   1.23826711598026E-22
      4.04621209767060E-09   4.04621209739904E-09  -8.97570761060564E-19  -1.95363458770093E-01  -1.95363458770093E-01
      0.00000000000000E+00   0.00000000000000E+00   9.72119917588299E-16   0.00000000000000E+00   9.72119917588299E-16
      4.02994135391390E-18  -1.95366408107087E-01  -1.94091629723969E-01   0.00000000000000E+00  -4.12655259734223E-18
     -9.55775064454683E-23  -4.04621306539231E-09  -4.04621306951896E-09  -3.13237059285333E-18
      3.29014417776563E-07
      0.00000000000000E+00  -4.04621989767759E-12   0.00000000000000E+00  -2.82794808113153E-19   1.23826721135025E-22
      4.04618401172947E-09   4.04618401144680E-09  -8.97571630630167E-19  -1.95362967160712E-01  -1.95362967160712E-01
      0.00000000000000E+00   0.00000000000000E+00   9.85666178231904E-16   0.00000000000000E+00   9.85666178231904E-16
      4.02994628224479E-18  -1.95367120821963E-01  -1.94092351283444E-01   0.00000000000000E+00  -4.43996298071304E-18
     -9.55776114139681E-23  -4.04618499267292E-09  -4.04618499711297E-09  -3.13237465161462E-18
      3.34014417776563E-07
      0.00000000000000E+00  -4.04612805294038E-12   0.00000000000000E+00  -1.24021861479304E-19   1.23826912175540E-22
      4.04616526733020E-09   4.04616526720630E-09  -8.97572290418369E-19  -1.95362577995846E-01  -1.95362577995846E-01
      0.00000000000000E+00   0.00000000000000E+00   8.75978136890532E-16   0.00000000000000E+00   8.75978136890532E-16
      4.02995066213548E-18  -1.95367888593366E-01  -1.94093124995149E-01   0.00000000000000E+00  -4.46522914018367E-18
     -9.55777140321008E-23  -4.04616613871911E-09  -4.04616614318444E-09  -3.13237837171711E-18
      3.39014417776563E-07
      0.00000000000000E+00  -4.04612805294038E-12   0.00000000000000E+00   9.09053200374599E-20   1.23827336790855E-22
      4.04616228219955E-09   4.04616228229058E-09  -8.97572565190229E-19  -1.95362385583115E-01  -1.95362385583115E-01
      0.00000000000000E+00   0.00000000000000E+00   6.05508424290626E-16   0.00000000000000E+00   6.05508424290626E-16
      4.02995368967760E-18  -1.95368635070631E-01  -1.94093872498276E-01   0.00000000000000E+00  -3.88462549698180E-18
     -9.55777999572196E-23  -4.04616288391428E-09  -4.04616288779900E-09  -3.13238112448737E-18
      3.44014417776563E-07
      0.00000000000000E+00  -4.04621989767759E-12   0.00000000000000E+00   1.42515980614093E-18   1.23828037183545E-22
      4.04618205816983E-09   4.04618205959511E-09  -8.97572257611254E-19  -1.95362497549975E-01  -1.95362497549975E-01
      0.00000000000000E+00   0.00000000000000E+00   1.42754065841571E-16   0.00000000000000E+00   1.42754065841571E-16
      4.02995440344793E-18  -1.95369254606983E-01  -1.94094485949963E-01   0.00000000000000E+00  -3.60751661491372E-18
     -9.55778510519598E-23  -4.04618219874157E-09  -4.04618220234918E-09  -3.13238214583668E-18
      3.49014417776563E-07
      0.00000000000000E+00  -4.04621989767759E-12   0.00000000000000E+00   1.03094123933441E-18   1.23829036149533E-22
      4.04623149200074E-09   4.04623149303181E-09  -8.97571165405368E-19  -1.95363026005482E-01  -1.95363026005482E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.31201087507799E-16   0.00000000000000E+00  -5.31201087507799E-16
      4.02995174744249E-18  -1.95369614097639E-01  -1.94094830078481E-01   0.00000000000000E+00  -6.56371945422167E-19
     -9.55778462165806E-23  -4.04623096117426E-09  -4.04623096183073E-09  -3.13238058203712E-18
      3.54014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   5.30845755069149E-18   1.23830326259335E-22
      4.04631641571588E-09   4.04631642102446E-09  -8.97569106062086E-19  -1.95364074554236E-01  -1.95364074554236E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.41509995467083E-15   0.00000000000000E+00  -1.41509995467083E-15
      4.02994467194272E-18  -1.95369559228468E-01  -1.94094748731836E-01   0.00000000000000E+00  -1.45149996370419E-18
     -9.55777629507444E-23  -4.04631500447291E-09  -4.04631500592451E-09  -3.13237556588063E-18
      3.59014417776563E-07
      0.00000000000000E+00  -4.04649543188921E-12   0.00000000000000E+00   2.33549000807905E-18   1.23831858267504E-22
      4.04644039453250E-09   4.04644039686811E-09  -8.97565949183399E-19  -1.95365721065117E-01  -1.95365721065117E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.47942034855481E-15   0.00000000000000E+00  -2.47942034855481E-15
      4.02993227484097E-18  -1.95368926067808E-01  -1.94094076845782E-01   0.00000000000000E+00   6.12798073382242E-18
     -9.55775797535185E-23  -4.04643792357565E-09  -4.04643791744776E-09  -3.13236632565758E-18
      3.64014417776563E-07
      0.00000000000000E+00  -4.04667912136363E-12   0.00000000000000E+00   9.53689914460550E-18   1.23833530721008E-22
      4.04660330549882E-09   4.04660331503584E-09  -8.97561655135112E-19  -1.95367996786927E-01  -1.95367996786927E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.65856989890967E-15   0.00000000000000E+00  -3.65856989890967E-15
      4.02991398199148E-18  -1.95367558789380E-01  -1.94092658612075E-01   0.00000000000000E+00   3.90298405186182E-18
     -9.55772793625525E-23  -4.04659966036883E-09  -4.04659965646594E-09  -3.13235232685637E-18
      3.69014417776563E-07
      0.00000000000000E+00  -4.04686281083804E-12   0.00000000000000E+00   3.00639178976580E-18   1.23835181281564E-22
      4.04679985182425E-09   4.04679985483077E-09  -8.97556317876258E-19  -1.95370862934191E-01  -1.95370862934191E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.84477640505565E-15   0.00000000000000E+00  -4.84477640505565E-15
      4.02988975810945E-18  -1.95365333531950E-01  -1.94090371804309E-01   0.00000000000000E+00   1.63849469061326E-17
     -9.55768528037214E-23  -4.04679502643921E-09  -4.04679501005436E-09  -3.13233344023320E-18
      3.74014417776563E-07
      0.00000000000000E+00  -4.04695465557525E-12   0.00000000000000E+00   8.26036759813411E-18   1.23836583681944E-22
      4.04701809051819E-09   4.04701809877868E-09  -8.97550207734680E-19  -1.95374186847996E-01  -1.95374186847996E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.88459696344980E-15   0.00000000000000E+00  -5.88459696344980E-15
      4.02986033512464E-18  -1.95362188077830E-01  -1.94087157919167E-01   0.00000000000000E+00   1.60816135419025E-17
     -9.55763039808453E-23  -4.04701223026324E-09  -4.04701221418172E-09  -3.13231012738995E-18
      3.79014417776563E-07
      0.00000000000000E+00  -4.04723018978687E-12   0.00000000000000E+00   2.32271130535841E-18   1.23837450281439E-22
      4.04723829006894E-09   4.04723829239177E-09  -8.97543808775848E-19  -1.95377720657130E-01  -1.95377720657130E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.58058969179083E-15   0.00000000000000E+00  -6.58058969179083E-15
      4.02982743217618E-18  -1.95358155494000E-01  -1.94083056178027E-01   0.00000000000000E+00   2.69702977110820E-17
     -9.55756545223883E-23  -4.04723173877228E-09  -4.04723171180208E-09  -3.13228362340033E-18
      3.84014417776563E-07
      0.00000000000000E+00  -4.04741387926129E-12   0.00000000000000E+00   1.97212934049319E-18   1.23837445427170E-22
      4.04743227579663E-09   4.04743227776888E-09  -8.97537843453371E-19  -1.95381086238561E-01  -1.95381086238561E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.69867531687900E-15   0.00000000000000E+00  -6.69867531687900E-15
      4.02979393879959E-18  -1.95353399330746E-01  -1.94078238934115E-01   0.00000000000000E+00   2.94354132079810E-17
     -9.55749482340572E-23  -4.04742560852889E-09  -4.04742557909357E-09  -3.13225609534622E-18
      3.89014417776563E-07
      0.00000000000000E+00  -4.04750572399850E-12   0.00000000000000E+00   2.88176046065880E-18   1.23836209046189E-22
      4.04756366547535E-09   4.04756366835724E-09  -8.97533276183225E-19  -1.95383771099641E-01  -1.95383771099641E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.98413582097471E-15   0.00000000000000E+00  -5.98413582097471E-15
      4.02976401812049E-18  -1.95348246055796E-01  -1.94073044037526E-01   0.00000000000000E+00   2.81175768561935E-17
     -9.55742545512916E-23  -4.04755771233889E-09  -4.04755768422141E-09  -3.13223074193726E-18
      3.94014417776563E-07
      0.00000000000000E+00  -4.04759756873570E-12   0.00000000000000E+00   1.89477107302509E-17   1.23833394477509E-22
      4.04758926064160E-09   4.04758927958943E-09  -8.97531286321666E-19  -1.95385140323037E-01  -1.95385140323037E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.18645395981561E-15   0.00000000000000E+00  -4.18645395981561E-15
      4.02974308585069E-18  -1.95343209530050E-01  -1.94067998880375E-01   0.00000000000000E+00   6.86976501797733E-18
     -9.55736699612920E-23  -4.04758510000514E-09  -4.04758509313547E-09  -3.13221179952902E-18
      3.99014417776563E-07
      0.00000000000000E+00  -4.04750572399850E-12   0.00000000000000E+00   1.18207233976975E-17   1.23828718873741E-22
      4.04746191753748E-09   4.04746192935832E-09  -8.97533202575172E-19  -1.95384469162242E-01  -1.95384469162242E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09377953694605E-15   0.00000000000000E+00  -1.09377953694605E-15
      4.02973761695300E-18  -1.95339000863059E-01  -1.94063829358673E-01   0.00000000000000E+00   3.07178039649918E-18
     -9.55733165503360E-23  -4.04746083865047E-09  -4.04746083557879E-09  -3.13220441437783E-18
      4.04014417776563E-07
      0.00000000000000E+00  -4.04713834504967E-12   0.00000000000000E+00   1.13629342482596E-16   1.23822028259533E-22
      4.04713509551765E-09   4.04713520914712E-09  -8.97540388632206E-19  -1.95381001836318E-01  -1.95381001836318E-01
      0.00000000000000E+00   0.00000000000000E+00   3.42250363462065E-15   0.00000000000000E+00   3.42250363462065E-15
      4.02975472947118E-18  -1.95336516544670E-01  -1.94061446584939E-01   0.00000000000000E+00  -1.17664726404047E-16
     -9.55733364671519E-23  -4.04713851398593E-09  -4.04713863165075E-09  -3.13221434083897E-18
      4.09014417776563E-07
      0.00000000000000E+00  -4.04649543188921E-12   0.00000000000000E+00   3.17440569214647E-17   1.23813366972907E-22
      4.04656936796232E-09   4.04656939970650E-09  -8.97554080701229E-19  -1.95374037106005E-01  -1.95374037106005E-01
      0.00000000000000E+00   0.00000000000000E+00   9.35721165357063E-15   0.00000000000000E+00   9.35721165357063E-15
      4.02980151552944E-18  -1.95336796596288E-01  -1.94061903004208E-01   0.00000000000000E+00  -5.91962867013044E-17
     -9.55738815909034E-23  -4.04657869772177E-09  -4.04657875691815E-09  -3.13224743482822E-18
      4.14014417776563E-07
      0.00000000000000E+00  -4.04576067399155E-12   0.00000000000000E+00   2.83702760339749E-16   1.23803062297520E-22
      4.04574023990268E-09   4.04574052360556E-09  -8.97575168279481E-19  -1.95363044625234E-01  -1.95363044625234E-01
      0.00000000000000E+00   0.00000000000000E+00   1.65162679804663E-14   0.00000000000000E+00   1.65162679804663E-14
      4.02988409686935E-18  -1.95340948018580E-01  -1.94066313395670E-01   0.00000000000000E+00  -3.50523300519857E-16
     -9.55750974619414E-23  -4.04575668935015E-09  -4.04575703987354E-09  -3.13230892858986E-18
      4.19014417776563E-07
      0.00000000000000E+00  -4.04465853714506E-12   0.00000000000000E+00   4.27237460835570E-17   1.23791782867012E-22
      4.04464815502152E-09   4.04464819774539E-09  -8.97603938532286E-19  -1.95347803712469E-01  -1.95347803712469E-01
      0.00000000000000E+00   0.00000000000000E+00   2.44628196913866E-14   0.00000000000000E+00   2.44628196913866E-14
      4.03000641096781E-18  -1.95350024921576E-01  -1.94075731867812E-01   0.00000000000000E+00  -1.38626643516283E-16
     -9.55771016352846E-23  -4.04467252193834E-09  -4.04467266056508E-09  -3.13240247243552E-18
      4.24014417776563E-07
      0.00000000000000E+00  -4.04337271082416E-12   0.00000000000000E+00   3.49982278438544E-16   1.23780616927556E-22
      4.04332777358408E-09   4.04332812356648E-09  -8.97639782999560E-19  -1.95328562588823E-01  -1.95328562588823E-01
      0.00000000000000E+00   0.00000000000000E+00   3.24784555601076E-14   0.00000000000000E+00   3.24784555601076E-14
      4.03016880324560E-18  -1.95364870588418E-01  -1.94090991009633E-01   0.00000000000000E+00  -5.03811534582702E-16
     -9.55799564257553E-23  -4.04336009821041E-09  -4.04336060202204E-09  -3.13252902024604E-18
      4.29014417776563E-07
      0.00000000000000E+00  -4.04181135029163E-12   0.00000000000000E+00   1.22432641491986E-17   1.23771069725240E-22
      4.04185883314270E-09   4.04185884538609E-09  -8.97680912070521E-19  -1.95306198533717E-01  -1.95306198533717E-01
      0.00000000000000E+00   0.00000000000000E+00   3.95328849010083E-14   0.00000000000000E+00   3.95328849010083E-14
      4.03036646767011E-18  -1.95385916066131E-01  -1.94112497071717E-01   0.00000000000000E+00  -1.84651506309354E-16
     -9.55836380738853E-23  -4.04189819361939E-09  -4.04189837827099E-09  -3.13268555559959E-18
      4.34014417776563E-07
      0.00000000000000E+00  -4.04034183449631E-12   0.00000000000000E+00  -7.39484355417004E-18   1.23765075589811E-22
      4.04037279293749E-09   4.04037278554277E-09  -8.97724097135083E-19  -1.95282363597020E-01  -1.95282363597020E-01
      0.00000000000000E+00   0.00000000000000E+00   4.43031218226850E-14   0.00000000000000E+00   4.43031218226850E-14
      4.03058798327922E-18  -1.95412956751439E-01  -1.94140004449130E-01   0.00000000000000E+00  -1.90758150189627E-16
     -9.55880038727963E-23  -4.04041689790635E-09  -4.04041708866459E-09  -3.13286388614414E-18
      4.39014417776563E-07
      0.00000000000000E+00  -4.03905600817540E-12   0.00000000000000E+00  -8.96732352779533E-18   1.23764897610467E-22
      4.03905819505464E-09   4.03905818608744E-09  -8.97764501913802E-19  -1.95259587565986E-01  -1.95259587565986E-01
      0.00000000000000E+00   0.00000000000000E+00   4.52151844804477E-14   0.00000000000000E+00   4.52151844804477E-14
      4.03081405920163E-18  -1.95444914135767E-01  -1.94172375728025E-01   0.00000000000000E+00  -2.06878764630337E-16
     -9.55927626497915E-23  -4.03910319439307E-09  -4.03910340127193E-09  -3.13304955728782E-18
      4.44014417776563E-07
      0.00000000000000E+00  -4.03813756080333E-12   0.00000000000000E+00  -2.55287426313764E-18   1.23772967252367E-22
      4.03815865223891E-09   4.03815864968615E-09  -8.97795655375827E-19  -1.95241307357640E-01  -1.95241307357641E-01
      0.00000000000000E+00   0.00000000000000E+00   4.05535058030951E-14   0.00000000000000E+00   4.05535058030951E-14
      4.03101682673064E-18  -1.95479618039404E-01  -1.94207364516257E-01   0.00000000000000E+00  -2.07461807058480E-16
     -9.55974501293041E-23  -4.03819899573005E-09  -4.03819920319196E-09  -3.13322117135481E-18
      4.49014417776563E-07
      0.00000000000000E+00  -4.03795387132891E-12   0.00000000000000E+00   2.44067806252108E-16   1.23791641508642E-22
      4.03796395844526E-09   4.03796420251319E-09  -8.97809626023592E-19  -1.95231790222873E-01  -1.95231790222873E-01
      0.00000000000000E+00   0.00000000000000E+00   2.86276168005606E-14   0.00000000000000E+00   2.86276168005606E-14
      4.03115996481464E-18  -1.95513640330821E-01  -1.94241451912045E-01   0.00000000000000E+00  -4.20636108469894E-16
     -9.56014200938832E-23  -4.03799240949378E-09  -4.03799283012999E-09  -3.13335033879105E-18
      4.54014417776563E-07
      0.00000000000000E+00  -4.03878047396378E-12   0.00000000000000E+00   1.27477821372316E-16   1.23822847949221E-22
      4.03879131162558E-09   4.03879143910352E-09  -8.97797471560295E-19  -1.95235911348022E-01  -1.95235911348022E-01
      0.00000000000000E+00   0.00000000000000E+00   8.00600418485746E-15   0.00000000000000E+00   8.00600418485746E-15
      4.03119999483557E-18  -1.95542224336680E-01  -1.94269781756324E-01   0.00000000000000E+00  -2.32986025547188E-16
     -9.56038536661204E-23  -4.03879921212159E-09  -4.03879944510771E-09  -3.13340252327527E-18
      4.56514417776563E-07
      0.00000000000000E+00  -4.03951523186144E-12   0.00000000000000E+00   1.42678977770338E-17   1.23841785148478E-22
      4.03950109401720E-09   4.03950110828522E-09  -8.97783702227184E-19  -1.95242018795606E-01  -1.95242018795606E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.63202979602945E-15   0.00000000000000E+00  -4.63202979602945E-15
      4.03118841476108E-18  -1.95554478830692E-01  -1.94281816611508E-01   0.00000000000000E+00  -7.25727637753847E-17
     -9.56045738155117E-23  -4.03949640368256E-09  -4.03949647625542E-09  -3.13340471253390E-18
      4.57358167776563E-07
      0.00000000000000E+00  -4.03979076607306E-12   0.00000000000000E+00   1.62592141460315E-17   1.23848563295477E-22
      4.03977593827710E-09   4.03977595453644E-09  -8.97778133798776E-19  -1.95244565833296E-01  -1.95244565833296E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.16774087894438E-15   0.00000000000000E+00  -9.16774087894438E-15
      4.03118067947971E-18  -1.95558355499302E-01  -1.94285608117914E-01   0.00000000000000E+00  -5.78835889891775E-17
     -9.56047563318803E-23  -4.03976672891187E-09  -4.03976678679556E-09  -3.13340254568094E-18
      4.58497230276563E-07
      0.00000000000000E+00  -4.04024998975910E-12   0.00000000000000E+00   1.94512224337364E-17   1.23858434590004E-22
      4.04021518843062E-09   4.04021520788196E-09  -8.97768824972659E-19  -1.95248951707429E-01  -1.95248951707429E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.57970086953430E-14   0.00000000000000E+00  -1.57970086953430E-14
      4.03116268569950E-18  -1.95563046219784E-01  -1.94290162538473E-01   0.00000000000000E+00  -3.62855897626624E-17
     -9.56048791174705E-23  -4.04019937458758E-09  -4.04019941087327E-09  -3.13339386072683E-18
      4.60034964651563E-07
      0.00000000000000E+00  -4.04089290291955E-12   0.00000000000000E+00   2.95289749473110E-17   1.23873104558029E-22
      4.04094197769340E-09   4.04094200722250E-09  -8.97752715068531E-19  -1.95256753475719E-01  -1.95256753475719E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.56937001404342E-14   0.00000000000000E+00  -2.56937001404342E-14
      4.03112317561357E-18  -1.95568204794040E-01  -1.94295095250684E-01   0.00000000000000E+00  -8.75250104851918E-18
     -9.56047929478783E-23  -4.04091630476977E-09  -4.04091631352237E-09  -3.13337046054504E-18
      4.62110906057813E-07
      0.00000000000000E+00  -4.04217872924046E-12   0.00000000000000E+00   5.33035920196111E-17   1.23895397826972E-22
      4.04218971635973E-09   4.04218976966344E-09  -8.97723831493054E-19  -1.95271092771776E-01  -1.95271092771776E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.08207737786863E-14   0.00000000000000E+00  -4.08207737786863E-14
      4.03103843407904E-18  -1.95572538551727E-01  -1.94299040664478E-01   0.00000000000000E+00   2.61085374611999E-17
     -9.56041411003877E-23  -4.04214897499811E-09  -4.04214894888966E-09  -3.13331460258599E-18
      4.64913426956250E-07
      0.00000000000000E+00  -4.04438300293344E-12   0.00000000000000E+00   1.34586084835185E-16   1.23929986042560E-22
      4.04441129870712E-09   4.04441143329333E-09  -8.97670251558315E-19  -1.95298286052133E-01  -1.95298286052133E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.44675561310459E-14   0.00000000000000E+00  -6.44675561310459E-14
      4.03085776240572E-18  -1.95572281832499E-01  -1.94298091466846E-01   0.00000000000000E+00   3.75989897570669E-17
     -9.56020924718458E-23  -4.04434700333609E-09  -4.04434696573720E-09  -3.13318751084740E-18
      4.68696830169141E-07
      0.00000000000000E+00  -4.04851601610778E-12   0.00000000000000E+00   4.40579870818173E-16   1.23984149124355E-22
      4.04848677283560E-09   4.04848721341560E-09  -8.97568082082542E-19  -1.95351174752193E-01  -1.95351174752193E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01876655474832E-13   0.00000000000000E+00  -1.01876655474832E-13
      4.03047232194008E-18  -1.95557337273277E-01  -1.94281874677672E-01   0.00000000000000E+00  -1.24682771741060E-16
     -9.55967235821184E-23  -4.04838521207726E-09  -4.04838533676012E-09  -3.13290423985753E-18
      4.73696830169141E-07
      0.00000000000000E+00  -4.05586359508438E-12   0.00000000000000E+00   1.41443772061074E-16   1.24064684658085E-22
      4.05582389129937E-09   4.05582403274326E-09  -8.97377204177869E-19  -1.95451798382357E-01  -1.95451798382357E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.58363964347289E-13   0.00000000000000E+00  -1.58363964347289E-13
      4.02968050211834E-18  -1.95504121409873E-01  -1.94226364978268E-01   0.00000000000000E+00   4.37575413962391E-16
     -9.55841347497569E-23  -4.05566610635423E-09  -4.05566566877892E-09  -3.13230329794047E-18
      4.78696830169141E-07
      0.00000000000000E+00  -4.06495622406793E-12   0.00000000000000E+00   9.22783129809469E-17   1.24147219303789E-22
      4.06495778602048E-09   4.06495787829892E-09  -8.97132537545585E-19  -1.95582600376217E-01  -1.95582600376217E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.17396888450159E-13   0.00000000000000E+00  -2.17396888450159E-13
      4.02859351767609E-18  -1.95410558818102E-01  -1.94129943253799E-01   0.00000000000000E+00   7.63713099483560E-16
     -9.55654377658739E-23  -4.06474124512347E-09  -4.06474048141047E-09  -3.13146098013050E-18
      4.81196830169141E-07
      0.00000000000000E+00  -4.06991583987713E-12   0.00000000000000E+00   1.00713984134927E-16   1.24187913257146E-22
      4.06994067948834E-09   4.06994078020245E-09  -8.96997454198766E-19  -1.95655249294408E-01  -1.95655249294408E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.46871884254871E-13   0.00000000000000E+00  -2.46871884254871E-13
      4.02797633796545E-18  -1.95352930544468E-01  -1.94070754351140E-01   0.00000000000000E+00   8.96561069972613E-16
     -9.55545121969197E-23  -4.06969480487917E-09  -4.06969390831820E-09  -3.13097888376668E-18
      4.84571830169141E-07
      0.00000000000000E+00  -4.07726341885374E-12   0.00000000000000E+00   1.09714490043127E-16   1.24238514588917E-22
      4.07726573240584E-09   4.07726584212045E-09  -8.96795254714752E-19  -1.95764902780182E-01  -1.95764902780181E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.84367401492716E-13   0.00000000000000E+00  -2.84367401492716E-13
      4.02701659798541E-18  -1.95254065529420E-01  -1.93969593307881E-01   0.00000000000000E+00   1.07760989608758E-15
     -9.55368865191748E-23  -4.07698255232876E-09  -4.07698147471896E-09  -3.13022134327066E-18
      4.89128080169141E-07
      0.00000000000000E+00  -4.08764187415819E-12   0.00000000000000E+00   1.23708110470740E-16   1.24288728258412E-22
      4.08760275242584E-09   4.08760287613408E-09  -8.96501482738453E-19  -1.95926269689585E-01  -1.95926269689585E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.23871208041177E-13   0.00000000000000E+00  -3.23871208041177E-13
      4.02554095979377E-18  -1.95081895150604E-01  -1.93794178571926E-01   0.00000000000000E+00   1.28966146485691E-15
     -9.55084002437686E-23  -4.08728029458741E-09  -4.08727900492604E-09  -3.12903947705532E-18
      4.94128080169141E-07
      0.00000000000000E+00  -4.09820401893705E-12   0.00000000000000E+00   1.15143025061282E-16   1.24305893814515E-22
      4.09821380429015E-09   4.09821391943330E-09  -8.96185967324638E-19  -1.96102817186563E-01  -1.96102817186563E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.42618847816672E-13   0.00000000000000E+00  -3.42618847816672E-13
      4.02382786555469E-18  -1.94851920670466E-01  -1.93560866846716E-01   0.00000000000000E+00   1.46404434143868E-15
     -9.54732620915201E-23  -4.09787276462973E-09  -4.09787130058549E-09  -3.12764189823005E-18
      4.99128080169141E-07
      0.00000000000000E+00  -4.10637820054852E-12   0.00000000000000E+00   1.61237272977615E-16   1.24267380693250E-22
      4.10638087739425E-09   4.10638103863165E-09  -8.95921476972953E-19  -1.96255462676734E-01  -1.96255462676734E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.24084014187715E-13   0.00000000000000E+00  -3.24084014187715E-13
      4.02220744548375E-18  -1.94594244577743E-01  -1.93300611753219E-01   0.00000000000000E+00   1.44501607033553E-15
     -9.54372615920293E-23  -4.10605839963344E-09  -4.10605695461747E-09  -3.12628596851080E-18
      5.04128080169141E-07
      0.00000000000000E+00  -4.10996014529961E-12   0.00000000000000E+00   3.71159151079629E-17   1.24155501291367E-22
      4.11000044118237E-09   4.11000047829841E-09  -8.95763749239071E-19  -1.96354293727655E-01  -1.96354293727655E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.55168391793570E-13   0.00000000000000E+00  -2.55168391793570E-13
      4.02093160352478E-18  -1.94331444248724E-01  -1.93036649281431E-01   0.00000000000000E+00   1.39807237908486E-15
     -9.54047788650221E-23  -4.10974670797890E-09  -4.10974530990662E-09  -3.12516785428571E-18
      5.09128080169141E-07
      0.00000000000000E+00  -4.10665373476014E-12   0.00000000000000E+00  -3.27932954488658E-17   1.23954817640051E-22
      4.10670072595339E-09   4.10670069316021E-09  -8.95777742576138E-19  -1.96363998392451E-01  -1.96363998392451E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23920562141439E-13   0.00000000000000E+00  -1.23920562141439E-13
      4.02031200071408E-18  -1.94096172346308E-01  -1.92802375582545E-01   0.00000000000000E+00   1.03683268216137E-15
     -9.53815551393270E-23  -4.10657780943066E-09  -4.10657677259808E-09  -3.12453425813794E-18
      5.14128080169141E-07
      0.00000000000000E+00  -4.09407100576271E-12   0.00000000000000E+00   2.40156038871018E-15   1.23654799322351E-22
      4.09405639355008E-09   4.09405879511059E-09  -8.96033156895880E-19  -1.96246172794533E-01  -1.96246172794533E-01
      0.00000000000000E+00   0.00000000000000E+00   7.83755472916941E-14   0.00000000000000E+00   7.83755472916941E-14
      4.02070387845054E-18  -1.93930944315603E-01  -1.92641067487905E-01   0.00000000000000E+00  -2.16103982578795E-15
     -9.53744989517569E-23  -4.09413500961796E-09  -4.09413717065788E-09  -3.12467072155465E-18
      5.19128080169141E-07
      0.00000000000000E+00  -4.06991583987713E-12   0.00000000000000E+00   2.13718569984587E-14   1.23252842995355E-22
      4.06990139834295E-09   4.06992277020008E-09  -8.96597426455852E-19  -1.95963025097615E-01  -1.95963025097615E-01
      0.00000000000000E+00   0.00000000000000E+00   3.54591436620949E-13   0.00000000000000E+00   3.54591436620949E-13
      4.02247683563364E-18  -1.93886469108662E-01  -1.92604115483314E-01   0.00000000000000E+00  -2.23956034020370E-14
     -9.53912416153517E-23  -4.07025496603320E-09  -4.07027736163670E-09  -3.12587940917779E-18
      5.24128080169141E-07
      0.00000000000000E+00  -4.03271872130808E-12   0.00000000000000E+00   5.62348144268337E-15   1.22757734252012E-22
      4.03276244240758E-09   4.03276806588915E-09  -8.97526374825954E-19  -1.95482422140119E-01  -1.95482422140120E-01
      0.00000000000000E+00   0.00000000000000E+00   6.99005517133249E-13   0.00000000000000E+00   6.99005517133249E-13
      4.02597186321931E-18  -1.94018022666935E-01  -1.92747261510457E-01   0.00000000000000E+00  -7.94710641225568E-15
     -9.54395783597306E-23  -4.03345912429978E-09  -4.03346707140629E-09  -3.12844548839335E-18
      5.29128080169141E-07
      0.00000000000000E+00  -3.98229596058115E-12   0.00000000000000E+00   4.45618927684039E-14   1.22192488836240E-22
      3.98225952825028E-09   3.98230409014317E-09  -8.98850951783080E-19  -1.94784998926374E-01  -1.94784998926375E-01
      0.00000000000000E+00   0.00000000000000E+00   1.09373198688487E-12   0.00000000000000E+00   1.09373198688487E-12
      4.03144052315373E-18  -1.94380117935404E-01  -1.93125143858404E-01   0.00000000000000E+00  -4.91399819090648E-14
     -9.55260045513425E-23  -3.98334868214805E-09  -3.98339782213006E-09  -3.13258957137065E-18
      5.34128080169141E-07
      0.00000000000000E+00  -3.91974969454283E-12   0.00000000000000E+00   6.51418815774017E-15   1.21600120587109E-22
      3.91975592241840E-09   3.91976243660668E-09  -9.00563302781235E-19  -1.93871800210311E-01  -1.93871800210312E-01
      0.00000000000000E+00   0.00000000000000E+00   1.50713997604122E-12   0.00000000000000E+00   1.50713997604122E-12
      4.03897622303394E-18  -1.95018362172365E-01  -1.93782950279786E-01   0.00000000000000E+00  -1.25753858974231E-14
     -9.56554575507947E-23  -3.92125700119673E-09  -3.92126957658272E-09  -3.13841292025270E-18
      5.39128080169140E-07
      0.00000000000000E+00  -3.84857002320699E-12   0.00000000000000E+00   4.47572547369231E-14   1.21042558682016E-22
      3.84853319779236E-09   3.84857795504722E-09  -9.02599188496161E-19  -1.92773781262923E-01  -1.92773781262925E-01
      0.00000000000000E+00   0.00000000000000E+00   1.89054843551352E-12   0.00000000000000E+00   1.89054843551352E-12
      4.04842896521150E-18  -1.95960894196708E-01  -1.94747801007215E-01   0.00000000000000E+00  -5.36426323561027E-14
     -9.58277244103952E-23  -3.85041486085028E-09  -3.85046850348273E-09  -3.14582977671534E-18
      5.44128080169140E-07
      0.00000000000000E+00  -3.77445132028052E-12   0.00000000000000E+00   1.55661083979288E-15   1.20610912647830E-22
      3.77446098683502E-09   3.77446254344598E-09  -9.04822522963758E-19  -1.91560137307625E-01  -1.91560137307627E-01
      0.00000000000000E+00   0.00000000000000E+00   2.18088654582865E-12   0.00000000000000E+00   2.18088654582865E-12
      4.05933339794065E-18  -1.97207053399390E-01  -1.96017206058221E-01   0.00000000000000E+00  -1.13714115515849E-14
     -9.60389156310531E-23  -3.77663205858016E-09  -3.77664342999181E-09  -3.15451087497689E-18
      5.49128080169140E-07
      0.00000000000000E+00  -3.70565961211208E-12   0.00000000000000E+00   7.61813739023283E-15   1.20415719007579E-22
      3.70567411564842E-09   3.70568173378593E-09  -9.07012139726945E-19  -1.90345669874358E-01  -1.90345669874360E-01
      0.00000000000000E+00   0.00000000000000E+00   2.30032588389874E-12   0.00000000000000E+00   2.30032588389874E-12
      4.07083502736014E-18  -1.98718121528762E-01  -1.97549908720445E-01   0.00000000000000E+00  -1.94009808614870E-14
     -9.62755517187315E-23  -3.70796265868888E-09  -3.70798205966983E-09  -3.16382288763320E-18
      5.54128080169140E-07
      0.00000000000000E+00  -3.65294073295496E-12   0.00000000000000E+00   3.39495770755116E-15   1.20594151609329E-22
      3.65288926844292E-09   3.65289266340075E-09  -9.08856417418606E-19  -1.89293681314034E-01  -1.89293681314036E-01
      0.00000000000000E+00   0.00000000000000E+00   2.16571986698831E-12   0.00000000000000E+00   2.16571986698831E-12
      4.08166362669508E-18  -2.00406981693849E-01  -1.99255441910419E-01   0.00000000000000E+00  -1.46767409886697E-14
     -9.65181193695858E-23  -3.65504370652665E-09  -3.65505838326774E-09  -3.17280720927648E-18
      5.59128080169140E-07
      0.00000000000000E+00  -3.62878556706938E-12   0.00000000000000E+00  -2.47826556337902E-16   1.21287433568003E-22
      3.62875759946244E-09   3.62875735163601E-09  -9.09962050805494E-19  -1.88612340073915E-01  -1.88612340073917E-01
      0.00000000000000E+00   0.00000000000000E+00   1.69408039793796E-12   0.00000000000000E+00   1.69408039793796E-12
      4.09013402868477E-18  -2.02131296457327E-01  -2.00987508474954E-01   0.00000000000000E+00  -9.81211496992829E-15
     -9.67361094595730E-23  -3.63044161991887E-09  -3.63045143203394E-09  -3.18017197787928E-18
      5.64128080169140E-07
      0.00000000000000E+00  -3.64761373819692E-12   0.00000000000000E+00   5.33379062751302E-14   1.22624543351738E-22
      3.64759166885290E-09   3.64764500675929E-09  -9.09880166997361E-19  -1.88542044755224E-01  -1.88542044755224E-01
      0.00000000000000E+00   0.00000000000000E+00   8.16911900116941E-13   0.00000000000000E+00   8.16911900116941E-13
      4.09421858818536E-18  -2.03688256635578E-01  -2.02538811487724E-01   0.00000000000000E+00  -6.08526910096512E-14
     -9.68919440899959E-23  -3.64840106596831E-09  -3.64846191865941E-09  -3.18433842118800E-18
      5.69128080169140E-07
      0.00000000000000E+00  -3.72476331745125E-12   0.00000000000000E+00   7.79311636547498E-16   1.24681608975452E-22
      3.72470602782589E-09   3.72470680713765E-09  -9.08158666079320E-19  -1.89330480092846E-01  -1.89330480092845E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.07231317122908E-13   0.00000000000000E+00  -5.07231317122908E-13
      4.09168243159974E-18  -2.04812622729201E-01  -2.03639299522740E-01   0.00000000000000E+00  -2.76638030559719E-15
     -9.69412563555565E-23  -3.72419680944013E-09  -3.72419957582053E-09  -3.18352376552042E-18
      5.74128080169140E-07
      0.00000000000000E+00  -3.87538868647159E-12   0.00000000000000E+00   1.75848464839129E-13   1.27437871817068E-22
      3.87535747804978E-09   3.87553332651474E-09  -9.04408942502028E-19  -1.91199939693260E-01  -1.91199939693258E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.28080101059439E-12   0.00000000000000E+00  -2.28080101059439E-12
      4.08027842654677E-18  -2.05179791472654E-01  -2.03959563167995E-01   0.00000000000000E+00  -1.72340670671731E-13
     -9.68358900228244E-23  -3.87308018483338E-09  -3.87325252550415E-09  -3.17586948404474E-18
      5.79128080169140E-07
      0.00000000000000E+00  -4.11363393478792E-12   0.00000000000000E+00   2.41514608737949E-15   1.30729885040112E-22
      4.11362911114991E-09   4.11363152629613E-09  -8.98394357557627E-19  -1.94303332808438E-01  -1.94303332808433E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.45181385664427E-12   0.00000000000000E+00  -4.45181385664427E-12
      4.05801935726355E-18  -2.04413869725941E-01  -2.03119255916272E-01   0.00000000000000E+00   1.24697405264548E-14
     -9.65307485910823E-23  -4.10919218217991E-09  -4.10917971243948E-09  -3.15962499970592E-18
      5.84128080169140E-07
      0.00000000000000E+00  -4.44905091506980E-12   0.00000000000000E+00   3.38195172049854E-15   1.34215077667633E-22
      4.44904214694776E-09   4.44904552889962E-09  -8.90097026050529E-19  -1.98687251574992E-01  -1.98687251574985E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.91120637360262E-12   0.00000000000000E+00  -6.91120637360262E-12
      4.02346332539554E-18  -2.02111304805546E-01  -2.00711790669599E-01   0.00000000000000E+00   2.24657302336862E-14
     -9.59842512002936E-23  -4.44215678825615E-09  -4.44213432252601E-09  -3.13336629934501E-18
      5.89128080169140E-07
      0.00000000000000E+00  -4.88301729837537E-12   0.00000000000000E+00   4.37086595138047E-15   1.37376642748257E-22
      4.88297361977998E-09   4.88297799064606E-09  -8.79768534647236E-19  -2.04259979605467E-01  -2.04259979605457E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.48584526097667E-12   0.00000000000000E+00  -9.48584526097667E-12
      3.97603409909065E-18  -1.97880195971071E-01  -1.96344778064112E-01   0.00000000000000E+00   3.29248426563265E-14
     -9.51703792501874E-23  -4.87352507022764E-09  -4.87349214538508E-09  -3.09626556444342E-18
      5.94128080169140E-07
      0.00000000000000E+00  -5.40239928728393E-12   0.00000000000000E+00   5.22608421415293E-15   1.39558848329784E-22
      5.40239395520211E-09   5.40239918128647E-09  -8.67934464880695E-19  -2.10778953053489E-01  -2.10778953053477E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19432313995480E-11   0.00000000000000E+00  -1.19432313995480E-11
      3.91631794209291E-18  -1.91407308095570E-01  -1.89709014500640E-01   0.00000000000000E+00   4.26582385369072E-14
     -9.40860302962265E-23  -5.39049860812536E-09  -5.39045594988692E-09  -3.04838347721222E-18
      5.99128080169140E-07
      0.00000000000000E+00  -5.97348986324033E-12   0.00000000000000E+00   6.07218084607010E-15   1.40055187834772E-22
      5.97345005890542E-09   5.97345613108641E-09  -8.55369051597018E-19  -2.17853334416210E-01  -2.17853334416196E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.39928416140624E-11   0.00000000000000E+00  -1.39928416140624E-11
      3.84635373402260E-18  -1.82552276102461E-01  -1.80674708859846E-01   0.00000000000000E+00   5.00148987969785E-14
     -9.27651726635113E-23  -5.95951330437105E-09  -5.95946328947235E-09  -2.99098468242558E-18
      6.04128080169140E-07
      0.00000000000000E+00  -6.53622256811085E-12   0.00000000000000E+00   5.65450898285179E-15   1.38250045950316E-22
      6.53617197892550E-09   6.53617763343462E-09  -8.43068575514821E-19  -2.24950555285278E-01  -2.24950555285263E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.52761268902412E-11   0.00000000000000E+00  -1.52761268902412E-11
      3.76997309957139E-18  -1.71462555837654E-01  -1.69408098103686E-01   0.00000000000000E+00   5.48193563321372E-14
     -9.12944153385231E-23  -6.52095632590062E-09  -6.52090150654438E-09  -2.92690452405657E-18
      6.09128080169140E-07
      0.00000000000000E+00  -7.00242645417625E-12   0.00000000000000E+00   4.66808448438089E-15   1.33809141300735E-22
      7.00239044643178E-09   7.00239511451640E-09  -8.32262826330219E-19  -2.31388529335139E-01  -2.31388529335123E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53420347119480E-11   0.00000000000000E+00  -1.53420347119480E-11
      3.69326292601165E-18  -1.58693147447104E-01  -1.56491819213893E-01   0.00000000000000E+00   5.52595160923018E-14
     -8.98171864320169E-23  -6.98710833932045E-09  -6.98705307980445E-09  -2.86100009968144E-18
      6.14128080169140E-07
      0.00000000000000E+00  -7.25894880519688E-12   0.00000000000000E+00   2.63497098915851E-15   1.26849091870795E-22
      7.25891236082206E-09   7.25891499579318E-09  -8.24487386309818E-19  -2.36301417451934E-01  -2.36301417451920E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.36323480550051E-11   0.00000000000000E+00  -1.36323480550051E-11
      3.62510118573663E-18  -1.45306109442823E-01  -1.43023418260006E-01   0.00000000000000E+00   5.10812973796870E-14
     -8.85019064658229E-23  -7.24533372903547E-09  -7.24528264773818E-09  -2.80061379942681E-18
      6.19128080169140E-07
      0.00000000000000E+00  -7.18143184699372E-12   0.00000000000000E+00  -7.39879989978741E-16   1.17963147780156E-22
      7.18142874864086E-09   7.18142800876098E-09  -8.21681705936207E-19  -2.38593605357748E-01  -2.38593605357738E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.52410213985035E-12   0.00000000000000E+00  -9.52410213985035E-12
      3.57748067503738E-18  -1.32899874268820E-01  -1.30640297404988E-01   0.00000000000000E+00   4.19226746064663E-14
     -8.74899928114776E-23  -7.17194582929565E-09  -7.17190390662113E-09  -2.75579896910117E-18
      6.24128080169140E-07
      0.00000000000000E+00  -6.67049957390825E-12   0.00000000000000E+00  -4.95643108536737E-15   1.08025457310821E-22
      6.67048786677200E-09   6.67048291034102E-09  -8.26188301459432E-19  -2.36940926712213E-01  -2.36940926712211E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.48738278431737E-12   0.00000000000000E+00  -2.48738278431737E-12
      3.56504376111579E-18  -1.23466961588950E-01  -1.21366143787214E-01   0.00000000000000E+00   2.67086572106768E-14
     -8.69263877615761E-23  -6.66802223621382E-09  -6.66799552755670E-09  -2.73885545965636E-18
      6.29128080169140E-07
      0.00000000000000E+00  -5.70989546745473E-12   0.00000000000000E+00   1.47595012877726E-14   9.76884833825122E-23
      5.70991045086713E-09   5.70992521036852E-09  -8.40507028098729E-19  -2.29922607993273E-01  -2.29922607993280E-01
      0.00000000000000E+00   0.00000000000000E+00   7.57943018233792E-12   0.00000000000000E+00   7.57943018233792E-12
      3.60294091202748E-18  -1.18982237577618E-01  -1.17180889368089E-01   0.00000000000000E+00  -1.97799455015090E-14
     -8.70433670040539E-23  -5.71748486060526E-09  -5.71750464055085E-09  -2.76243388392875E-18
      6.34128080169140E-07
      0.00000000000000E+00  -4.41277224387283E-12   0.00000000000000E+00  -1.09698634155272E-14   8.65692045160305E-23
      4.41275778626665E-09   4.41274681640333E-09  -8.66840800119059E-19  -2.16307727013559E-01  -2.16307727013579E-01
      0.00000000000000E+00   0.00000000000000E+00   1.99126878573219E-11   0.00000000000000E+00   1.99126878573219E-11
      3.70250435131409E-18  -1.20794202343514E-01  -1.19397652640790E-01   0.00000000000000E+00  -2.78931120000954E-14
     -8.80546729360487E-23  -4.43263161114856E-09  -4.43265950426064E-09  -2.83566355119503E-18
      6.39128080169140E-07
      0.00000000000000E+00  -3.00966019355344E-12   0.00000000000000E+00   3.30630591328844E-13   7.28796427342761E-23
      3.00973729994720E-09   3.01006793053860E-09  -9.06729928104166E-19  -1.95401241171651E-01  -1.95401241171684E-01
      0.00000000000000E+00   0.00000000000000E+00   3.26731036807312E-11   0.00000000000000E+00   3.26731036807312E-11
      3.86586986971775E-18  -1.29101182562722E-01  -1.28142651151213E-01   0.00000000000000E+00  -4.13663541659840E-13
     -9.00085374661923E-23  -3.04232737067758E-09  -3.04274103421933E-09  -2.95913994161358E-18
      6.44128080169139E-07
      0.00000000000000E+00  -1.76700089913561E-12   0.00000000000000E+00  -1.13485983678664E-14   5.45194376713515E-23
      1.76703022986044E-09   1.76701888126212E-09  -9.61061878785467E-19  -1.67289034147725E-01  -1.67289034147768E-01
      0.00000000000000E+00   0.00000000000000E+00   4.32976142032733E-11   0.00000000000000E+00   4.32976142032733E-11
      4.08235794073411E-18  -1.42841108697226E-01  -1.42270757625804E-01   0.00000000000000E+00  -1.21349279615770E-13
     -9.30410165771651E-23  -1.81019514618569E-09  -1.81031649546540E-09  -3.12129606194865E-18
      6.49128080169139E-07
      0.00000000000000E+00  -8.72341313997089E-13   0.00000000000000E+00  -9.53208390364759E-15   3.13403009315546E-23
      8.72324492438028E-10   8.72314960354156E-10  -1.03018060090266E-18  -1.32875410817233E-01  -1.32875410817282E-01
      0.00000000000000E+00   0.00000000000000E+00   4.95761080998808E-11   0.00000000000000E+00   4.95761080998808E-11
      4.33023848123352E-18  -1.60123049051851E-01  -1.59832603904697E-01   0.00000000000000E+00  -1.88219313981359E-13
     -9.73161618138627E-23  -9.21702849139958E-10  -9.21891068454036E-10  -3.30005788033086E-18
      6.54128080169139E-07
      0.00000000000000E+00  -3.61776419860448E-13   0.00000000000000E+00  -5.86247953289661E-15   7.04451522018480E-24
      3.61770846402009E-10   3.61764983922483E-10  -1.11200896378344E-18  -9.42237376507160E-02  -9.42237376507667E-02
      0.00000000000000E+00   0.00000000000000E+00   5.07328106110103E-11   0.00000000000000E+00   5.07328106110103E-11
      4.58390253428857E-18  -1.78980130795500E-01  -1.78850173174971E-01   0.00000000000000E+00  -2.64456951894298E-13
     -1.02461098362972E-22  -4.12233337581496E-10  -4.12497794533493E-10  -3.47189357050512E-18
      6.59128080169139E-07
      0.00000000000000E+00  -1.42175653197251E-13   0.00000000000000E+00  -3.12471927012261E-15  -1.01910950865908E-23
      1.42204185105110E-10   1.42201060385829E-10  -1.19418381676723E-18  -5.70331488046698E-02  -5.70331488047155E-02
      0.00000000000000E+00   0.00000000000000E+00   4.57499478460594E-11   0.00000000000000E+00   4.57499478460594E-11
      4.81265227351887E-18  -1.97988163549337E-01  -1.97928950027632E-01   0.00000000000000E+00  -3.10276690550005E-13
     -1.07495122590257E-22  -1.87640731541232E-10  -1.87951008231889E-10  -3.61846845675164E-18
      6.64128080169139E-07
      0.00000000000000E+00  -7.56800634590020E-14   0.00000000000000E+00  -1.37036349600883E-15  -1.32634045707050E-23
      7.56502436735740E-11   7.56488733100647E-11  -1.25355247382110E-18  -3.09370521257374E-02  -3.09370521257708E-02
      0.00000000000000E+00   0.00000000000000E+00   3.34604980424985E-11   0.00000000000000E+00   3.34604980424985E-11
      4.97995476373136E-18  -2.16451518771094E-01  -2.16417144386134E-01   0.00000000000000E+00  -2.74437582875703E-13
     -1.11426553907398E-22  -1.08834933769576E-10  -1.09109371352563E-10  -3.72640228991026E-18
      6.69128080169139E-07
      0.00000000000000E+00  -6.18115081406655E-14   0.00000000000000E+00  -4.76983215295957E-16  -3.56405817166058E-24
      6.17901931516204E-11   6.17897161684016E-11  -1.28469544606053E-18  -1.76414589256260E-02  -1.76414589256467E-02
      0.00000000000000E+00   0.00000000000000E+00   2.07283244333065E-11   0.00000000000000E+00   2.07283244333065E-11
      5.08359638589789E-18  -2.34149629010565E-01  -2.34123632319281E-01   0.00000000000000E+00  -2.01752524799246E-13
     -1.14138692687195E-22  -8.23162880767953E-11  -8.25180406017087E-11  -3.79890093983736E-18
      6.74128080169139E-07
      0.00000000000000E+00  -6.11685949802128E-14   0.00000000000000E+00  -1.26373105045373E-16   1.49512298107997E-23
      6.11557598459271E-11   6.11556334728370E-11  -1.29831253101117E-18  -1.18302184732085E-02  -1.18302184732213E-02
      0.00000000000000E+00   0.00000000000000E+00   1.28769077956469E-11   0.00000000000000E+00   1.28769077956469E-11
      5.14798092487612E-18  -2.51032164175107E-01  -2.51008840964122E-01   0.00000000000000E+00  -1.53738296406275E-13
     -1.16133728402450E-22  -7.38788029719612E-11  -7.40325412684836E-11  -3.84966839386495E-18
      6.79128080169139E-07
      0.00000000000000E+00  -6.32810239359859E-14   0.00000000000000E+00  -1.40718120266149E-17   3.59319434424004E-23
      6.33107437461245E-11   6.33107296743484E-11  -1.30375230316999E-18  -9.26317370934639E-03  -9.26317370935536E-03
      0.00000000000000E+00   0.00000000000000E+00   8.97784568134221E-12   0.00000000000000E+00   8.97784568134221E-12
      5.19287015328284E-18  -2.67105707034008E-01  -2.67082933396101E-01   0.00000000000000E+00  -1.31321962272973E-13
     -1.17794307791158E-22  -7.21572533932999E-11  -7.22885753556907E-11  -3.88911785011285E-18
      6.84128080169139E-07
      0.00000000000000E+00  -6.61282107894193E-14   0.00000000000000E+00   2.18483537142078E-17   5.44795791693793E-23
      6.61033478043071E-11   6.61033696527153E-11  -1.30560673989967E-18  -8.04696226789795E-03  -8.04696226790499E-03
      0.00000000000000E+00   0.00000000000000E+00   7.04588894782362E-12   0.00000000000000E+00   7.04588894782362E-12
      5.22809959802196E-18  -2.82399969158933E-01  -2.82376924509969E-01   0.00000000000000E+00  -1.20332871639755E-13
     -1.19282956534545E-22  -7.30289257287801E-11  -7.31492586005391E-11  -3.92249285812228E-18
      6.89128080169139E-07
      0.00000000000000E+00  -6.93427765916827E-14   0.00000000000000E+00   4.06628056964462E-17   6.86086042847647E-23
      6.93169560817483E-11   6.93169967446226E-11  -1.30564684906947E-18  -7.52787052035123E-03  -7.52787052035715E-03
      0.00000000000000E+00   0.00000000000000E+00   5.92270395155016E-12   0.00000000000000E+00   5.92270395155016E-12
      5.25771311777971E-18  -2.96953584221910E-01  -2.96929881138063E-01   0.00000000000000E+00  -1.12958491762698E-13
     -1.20654746589330E-22  -7.51267422042890E-11  -7.52397006961724E-11  -3.95206626871024E-18
      6.94128080169139E-07
      0.00000000000000E+00  -7.32002555543988E-14   0.00000000000000E+00   6.05546266176536E-17   7.87462887602937E-23
      7.31918857150446E-11   7.31919462697500E-11  -1.30438525121335E-18  -7.54599682781328E-03  -7.54599682781837E-03
      0.00000000000000E+00   0.00000000000000E+00   5.08926847598068E-12   0.00000000000000E+00   5.08926847598068E-12
      5.28315946015961E-18  -3.10829382770591E-01  -3.10804721632635E-01   0.00000000000000E+00  -1.06414171345644E-13
     -1.21927277571316E-22  -7.81748005742634E-11  -7.82812147457310E-11  -3.97877420894627E-18
      6.99128080169139E-07
      0.00000000000000E+00  -7.82517161008128E-14   0.00000000000000E+00   9.13429752174984E-17   8.63400527735135E-23
      7.82884173470117E-11   7.82885086900733E-11  -1.30166831656553E-18  -8.19295773961845E-03  -8.19295773962271E-03
      0.00000000000000E+00   0.00000000000000E+00   4.25957445696816E-12   0.00000000000000E+00   4.25957445696816E-12
      5.30445733244445E-18  -3.24073900094709E-01  -3.24047894881356E-01   0.00000000000000E+00  -9.89201192674485E-14
     -1.23094480482822E-22  -8.24491630276511E-11  -8.25480831470416E-11  -4.00278901587892E-18
      7.04128080169139E-07
      0.00000000000000E+00  -8.58748292890375E-14   0.00000000000000E+00   1.49980396449639E-16   9.30956566708419E-23
      8.59076712850071E-11   8.59078212654966E-11  -1.29662667417765E-18  -9.85142070719915E-03  -9.85142070720229E-03
      0.00000000000000E+00   0.00000000000000E+00   3.13631825998355E-12   0.00000000000000E+00   3.13631825998355E-12
      5.32013892374437E-18  -3.36689211707077E-01  -3.36661160165033E-01   0.00000000000000E+00  -8.77202245602102E-14
     -1.24116649900052E-22  -8.89564193007960E-11  -8.90441395254803E-11  -4.02351224956672E-18
      7.09128080169139E-07
      0.00000000000000E+00  -9.92841609213364E-14   0.00000000000000E+00   2.10019463104952E-16   1.01074152480410E-22
      9.93353523536487E-11   9.93355623732129E-11  -1.28709811788139E-18  -1.34435417731851E-02  -1.34435417731863E-02
      0.00000000000000E+00   0.00000000000000E+00   1.23239487629892E-12   0.00000000000000E+00   1.23239487629892E-12
      5.32630089812586E-18  -3.48664335074140E-01  -3.48632653304880E-01   0.00000000000000E+00  -6.78133169107805E-14
     -1.24897075870827E-22  -1.00500143932476E-10  -1.00567957249511E-10  -4.03920278024448E-18
      7.14128080169139E-07
      0.00000000000000E+00  -1.26929426820802E-13   0.00000000000000E+00   5.26447181892883E-16   1.12998570896642E-22
      1.26970968780241E-10   1.26971495227536E-10  -1.26874549587922E-18  -2.07748357317470E-02  -2.07748357317447E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.27158299117913E-12   0.00000000000000E+00  -2.27158299117913E-12
      5.31494298316997E-18  -3.59962252955077E-01  -3.59922969086593E-01   0.00000000000000E+00  -3.17492836452715E-14
     -1.25250289905794E-22  -1.24668162952587E-10  -1.24699912236357E-10  -4.04619748729075E-18
      7.19128080169139E-07
      0.00000000000000E+00  -1.88373556012637E-13   0.00000000000000E+00   1.03353420549714E-15   1.30729058387436E-22
      1.88417461888385E-10   1.88418495422721E-10  -1.23595220251884E-18  -3.40683576764074E-02  -3.40683576763995E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.96852721954230E-12   0.00000000000000E+00  -7.96852721954230E-12
      5.27510034707225E-18  -3.70462617590065E-01  -3.70405770986428E-01   0.00000000000000E+00   2.33695453040964E-14
     -1.24958809203524E-22  -1.80473337748358E-10  -1.80449968203179E-10  -4.03914814455342E-18
      7.24128080169139E-07
      0.00000000000000E+00  -3.19527840744986E-13   0.00000000000000E+00   1.86318563988385E-15   1.50882219910008E-22
      3.19574446698750E-10   3.19576309884540E-10  -1.18797887633004E-18  -5.34521439620177E-02  -5.34521439620033E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.44774155520938E-11   0.00000000000000E+00  -1.44774155520938E-11
      5.20271326931179E-18  -3.79876269422222E-01  -3.79780154798198E-01   0.00000000000000E+00   7.62172457994789E-14
     -1.24046512060716E-22  -3.05175111578123E-10  -3.05098894332447E-10  -4.01473439298174E-18
      7.29128080169139E-07
      0.00000000000000E+00  -5.72376402277307E-13   0.00000000000000E+00   3.03486939007712E-15   1.67871501652591E-22
      5.72426097371598E-10   5.72429132241156E-10  -1.13188359180931E-18  -7.62647310017086E-02  -7.62647310016891E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.95184080064524E-11   0.00000000000000E+00  -1.95184080064524E-11
      5.10512122927952E-18  -3.87671895181021E-01  -3.87497712100841E-01   0.00000000000000E+00   1.04368187333995E-13
     -1.22790927673316E-22  -5.53015092421915E-10  -5.52910724234704E-10  -3.97323763747021E-18
      7.34128080169139E-07
      0.00000000000000E+00  -1.01065948823162E-12   0.00000000000000E+00   4.89965139290431E-15   1.80800902626797E-22
      1.01068558840278E-09   1.01069048805435E-09  -1.07571648935575E-18  -9.99040033627248E-02  -9.99040033627018E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.29441195822392E-11   0.00000000000000E+00  -2.29441195822392E-11
      4.99040063136833E-18  -3.93041833361430E-01  -3.92730662672368E-01   0.00000000000000E+00   1.14764722774035E-13
     -1.21382268237714E-22  -9.87861133194764E-10  -9.87746368472112E-10  -3.91468414201257E-18
      7.39128080169139E-07
      0.00000000000000E+00  -1.69554569358815E-12   0.00000000000000E+00   7.25236373834996E-15   1.90853152568933E-22
      1.69556292163957E-09   1.69557017400350E-09  -1.02391865269022E-18  -1.23043207981570E-01  -1.23043207981545E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.57504438870269E-11   0.00000000000000E+00  -2.57504438870269E-11
      4.86164841193320E-18  -3.94932151007528E-01  -3.94406103090485E-01   0.00000000000000E+00   1.22591753179630E-13
     -1.19838803841965E-22  -1.66994232186953E-09  -1.66981973011647E-09  -3.83772975924297E-18
      7.44128080169139E-07
      0.00000000000000E+00  -2.67011020009722E-12   0.00000000000000E+00   1.00469003222263E-14   1.98523100827782E-22
      2.67012861030242E-09   2.67013865720294E-09  -9.77540660002797E-19  -1.45262727072180E-01  -1.45262727072152E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86027771981133E-11   0.00000000000000E+00  -2.86027771981133E-11
      4.71863452594262E-18  -3.92137968581770E-01  -3.91305793047452E-01   0.00000000000000E+00   1.36396702427834E-13
     -1.18073783774608E-22  -2.64167227670714E-09  -2.64153588000483E-09  -3.74109386593983E-18
      7.49128080169138E-07
      0.00000000000000E+00  -3.94776233939112E-12   0.00000000000000E+00   1.29807147710371E-14   2.03451687838736E-22
      3.94771540913856E-09   3.94772838985353E-09  -9.36094345443614E-19  -1.66473461022932E-01  -1.66473461022900E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.15046521482057E-11   0.00000000000000E+00  -3.15046521482057E-11
      4.56111126520160E-18  -3.83447290341830E-01  -3.82213534954820E-01   0.00000000000000E+00   1.59170202325067E-13
     -1.15955251311818E-22  -3.91638290790753E-09  -3.91622373770532E-09  -3.62501691975799E-18
      7.54128080169138E-07
      0.00000000000000E+00  -5.51233743772134E-12   0.00000000000000E+00   1.57665830509261E-14   2.05123018292393E-22
      5.51236747743073E-09   5.51238324401398E-09  -8.98696028058378E-19  -1.86677686014735E-01  -1.86677686014701E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.41871043030966E-11   0.00000000000000E+00  -3.41871043030966E-11
      4.39017574368612E-18  -3.67778150105793E-01  -3.66052300733317E-01   0.00000000000000E+00   1.90917385314812E-13
     -1.13333205598753E-22  -5.47838705709609E-09  -5.47819613971089E-09  -3.49147971562774E-18
      7.59128080169138E-07
      0.00000000000000E+00  -7.32774051336531E-12   0.00000000000000E+00   1.82032164585767E-14   2.03459401357213E-22
      7.32775165014881E-09   7.32776985336547E-09  -8.64497173964125E-19  -2.05908922731889E-01  -2.05908922731853E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.64210134364493E-11   0.00000000000000E+00  -3.64210134364493E-11
      4.20807067650387E-18  -3.44270755125062E-01  -3.41973666790505E-01   0.00000000000000E+00   2.28923076524199E-13
     -1.10054595050494E-22  -7.29157776300544E-09  -7.29134883992902E-09  -3.34357350253974E-18
      7.64128080169138E-07
      0.00000000000000E+00  -9.34042608453106E-12   0.00000000000000E+00   2.01199632123849E-14   1.99089331555606E-22
      9.34037132602374E-09   9.34039144598715E-09  -8.32818688496974E-19  -2.24209992138671E-01  -2.24209992138633E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.81422516095103E-11   0.00000000000000E+00  -3.81422516095103E-11
      4.01735941845632E-18  -3.12365143116955E-01  -3.09434498813123E-01   0.00000000000000E+00   2.66165575775104E-13
     -1.05968097570015E-22  -9.30251535995331E-09  -9.30224919437764E-09  -3.18454072995934E-18
      7.69128080169138E-07
      0.00000000000000E+00  -1.14597433955947E-11   0.00000000000000E+00   2.11502091684892E-14   1.92752716250707E-22
      1.14597675131962E-08   1.14597886634055E-08  -8.03199181955849E-19  -2.41623972696119E-01  -2.41623972696080E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.95811317005754E-11   0.00000000000000E+00  -3.95811317005754E-11
      3.81945375995344E-18  -2.71968465565020E-01  -2.68370515874648E-01   0.00000000000000E+00   2.88872368190916E-13
     -1.00905399053084E-22  -1.14204964040730E-08  -1.14202075317049E-08  -3.01625457799759E-18
      7.74128080169138E-07
      0.00000000000000E+00  -1.34938287905298E-11   0.00000000000000E+00   2.02874563029600E-14   1.82476578835258E-22
      1.34937671524464E-08   1.34937874399029E-08  -7.75465082182721E-19  -2.58189441220970E-01  -2.58189441220929E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.14959298729050E-11   0.00000000000000E+00  -4.14959298729050E-11
      3.61197411058891E-18  -2.23897828378365E-01  -2.19659610214696E-01   0.00000000000000E+00   2.78263408268846E-13
     -9.48252498024906E-23  -1.34525697734382E-08  -1.34522915100300E-08  -2.83650902840619E-18
      7.79128080169138E-07
      0.00000000000000E+00  -1.51329818154726E-11   0.00000000000000E+00   1.63713388391326E-14   1.61034201211635E-22
      1.51329462260089E-08   1.51329625973479E-08  -7.49670254682626E-19  -2.73940200326823E-01  -2.73940200326778E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.46094181747969E-11   0.00000000000000E+00  -4.46094181747969E-11
      3.38892701971493E-18  -1.70365766419244E-01  -1.65612043591578E-01   0.00000000000000E+00   2.30155682683490E-13
     -8.85975432544818E-23  -1.50885833348557E-08  -1.50883531791731E-08  -2.63925676503231E-18
      7.84128080169138E-07
      0.00000000000000E+00  -1.61509888826808E-11   0.00000000000000E+00   2.29545863501328E-13   1.25306665278534E-22
      1.61509672721439E-08   1.61511968180076E-08  -7.25614845897656E-19  -2.88916806555416E-01  -2.88916806555369E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.72121449853559E-11   0.00000000000000E+00  -4.72121449853559E-11
      3.15286629478815E-18  -1.14535088399110E-01  -1.09461406501757E-01   0.00000000000000E+00  -4.41624544748521E-14
     -8.30095947429685E-23  -1.61039405105676E-08  -1.61039846730222E-08  -2.42725144889050E-18
      7.89128080169138E-07
      0.00000000000000E+00  -1.57450351442235E-11   0.00000000000000E+00  -3.26861399936010E-15   7.63750262289178E-23
      1.57450192871044E-08   1.57450160184904E-08  -7.02976254633530E-19  -3.03166921260278E-01  -3.03166921260231E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.74172378876877E-11   0.00000000000000E+00  -4.74172378876877E-11
      2.91578010534971E-18  -6.32350506609986E-02  -5.82893035095369E-02   0.00000000000000E+00   1.37317536165606E-13
     -6.63441458740957E-23  -1.56977360981389E-08  -1.56975987806028E-08  -2.21280385071618E-18
      7.94128080169138E-07
      0.00000000000000E+00  -1.23792010597793E-11   0.00000000000000E+00  -3.30636337043069E-14   3.50058959404841E-23
      1.23792066081990E-08   1.23791735445653E-08  -6.79264552884065E-19  -3.16765061746032E-01  -3.16765061745993E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.90711794024116E-11   0.00000000000000E+00  -3.90711794024116E-11
      2.72042420833765E-18  -3.02547782486016E-02  -2.63668417382600E-02   0.00000000000000E+00   1.08692929799015E-13
     -3.44253527747655E-23  -1.23402110580927E-08  -1.23401023651629E-08  -2.04115965545359E-18
      7.99128080169138E-07
      0.00000000000000E+00  -8.80340990607865E-12   0.00000000000000E+00  -3.51157047070058E-14   1.64975360849724E-23
      8.80341605035986E-09   8.80338093465517E-09  -6.52776805312634E-19  -3.29759114121923E-01  -3.29759114121896E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.69541016506654E-11   0.00000000000000E+00  -2.69541016506654E-11
      2.58565370008433E-18  -1.57182424254737E-02  -1.29530903042259E-02   0.00000000000000E+00   7.31787604790017E-14
     -1.67437461187428E-23  -8.77650001176497E-09  -8.77642683300450E-09  -1.93287689477169E-18
      8.04128080169138E-07
      0.00000000000000E+00  -7.04394027539406E-12   0.00000000000000E+00  -1.71972796368279E-14   9.61210448755867E-24
      7.04395791289596E-09   7.04394071561633E-09  -6.25168294665602E-19  -3.42150663827355E-01  -3.42150663827334E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.01465953051927E-11   0.00000000000000E+00  -2.01465953051927E-11
      2.48492072355836E-18  -1.01686337123276E-02  -7.95567346913113E-03   0.00000000000000E+00   4.00878807223726E-14
     -1.04305922657664E-23  -7.02383420819185E-09  -7.02379412031114E-09  -1.85975242889276E-18
      8.09128080169138E-07
      0.00000000000000E+00  -6.41324246498997E-12   0.00000000000000E+00  -6.07748841022263E-15   6.75819362380342E-24
      6.41327809539030E-09   6.41327201790190E-09  -5.97704932592768E-19  -3.53945561798154E-01  -3.53945561798137E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.72606763964743E-11   0.00000000000000E+00  -1.72606763964743E-11
      2.39861734157599E-18  -7.84990787772319E-03  -5.83473886511199E-03   0.00000000000000E+00   2.32194143975044E-14
     -7.79185046280176E-24  -6.39603456091981E-09  -6.39601134150542E-09  -1.80091240898323E-18
      8.14128080169138E-07
      0.00000000000000E+00  -6.20273432731032E-12   0.00000000000000E+00  -1.94609199735510E-15   5.25268541754529E-24
      6.20269480263601E-09   6.20269285654402E-09  -5.70918911845677E-19  -3.65154379103047E-01  -3.65154379103031E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.59094671400927E-11   0.00000000000000E+00  -1.59094671400927E-11
      2.31907000587553E-18  -6.62750350079147E-03  -4.67825364998218E-03   0.00000000000000E+00   1.63270991641730E-14
     -6.31363862627344E-24  -6.18679971650309E-09  -6.18678338940393E-09  -1.74815109402985E-18
      8.19128080169138E-07
      0.00000000000000E+00  -6.12154357961887E-12   0.00000000000000E+00  -6.82610907584050E-16   4.29242127569077E-24
      6.12152114316671E-09   6.12152046055581E-09  -5.45096768088599E-19  -3.75773149671092E-01  -3.75773149671077E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.50613726042679E-11   0.00000000000000E+00  -1.50613726042679E-11
      2.24376314285419E-18  -5.84037548436168E-03  -3.91643180519560E-03   0.00000000000000E+00   1.32126121630387E-14
     -5.31071379338150E-24  -6.10647230056371E-09  -6.10645908795155E-09  -1.69866637476559E-18
      8.24128080169138E-07
      0.00000000000000E+00  -6.08002975840106E-12   0.00000000000000E+00  -3.03594100242174E-16   3.62287815939395E-24
      6.08003077998407E-09   6.08003047638997E-09  -5.20561165727133E-19  -3.85744818075852E-01  -3.85744818075838E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.43095372127998E-11   0.00000000000000E+00  -1.43095372127998E-11
      2.17221545679019E-18  -5.28137421164424E-03  -3.37026460444405E-03   0.00000000000000E+00   1.12812491959035E-14
     -4.57493423062949E-24  -6.06573222042636E-09  -6.06572093917717E-09  -1.65165429106306E-18
      8.29128080169138E-07
      0.00000000000000E+00  -6.05256818197601E-12   0.00000000000000E+00  -1.77626242004319E-16   3.14147031048807E-24
      6.05260059718472E-09   6.05260041955848E-09  -4.97907450362103E-19  -3.94884084359553E-01  -3.94884084359540E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.33433305315621E-11   0.00000000000000E+00  -1.33433305315621E-11
      2.10549880413238E-18  -4.87260537110417E-03  -2.96983264745427E-03   0.00000000000000E+00   9.63645976909270E-15
     -4.02843948766294E-24  -6.03926672548668E-09  -6.03925708902691E-09  -1.60759135377028E-18
      8.34128080169138E-07
      0.00000000000000E+00  -6.03070913452062E-12   0.00000000000000E+00  -1.39490887815394E-16   2.79709970920847E-24
      6.03068124279305E-09   6.03068110330217E-09  -4.78213491861110E-19  -4.02798106772525E-01  -4.02798106772513E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17758047243756E-11   0.00000000000000E+00  -1.17758047243756E-11
      2.04661978051050E-18  -4.57826164501633E-03  -2.68190028201991E-03   0.00000000000000E+00   7.89599648442961E-15
     -3.63747237930599E-24  -6.01891319457427E-09  -6.01890529857779E-09  -1.56840628864939E-18
      8.39128080169138E-07
      0.00000000000000E+00  -6.01013591338614E-12   0.00000000000000E+00  -1.45800329877012E-16   2.56303515800148E-24
      6.01017292688414E-09   6.01017278108381E-09  -4.63153250234855E-19  -4.08840896942810E-01  -4.08840896942801E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.14943280951789E-12   0.00000000000000E+00  -9.14943280951789E-12
      2.00087261646291E-18  -4.38136989848115E-03  -2.49064195315396E-03   0.00000000000000E+00   5.80507471953512E-15
     -3.38960531208941E-24  -6.00102915334901E-09  -6.00102334827430E-09  -1.53771936622806E-18
      8.44128080169138E-07
      0.00000000000000E+00  -5.98800133171912E-12   0.00000000000000E+00  -1.14925568566249E-16   2.42781016846638E-24
      5.98804089236077E-09   5.98804077743521E-09  -4.55019420591169E-19  -4.12103720436446E-01  -4.12103720436441E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.00461689336983E-12   0.00000000000000E+00  -5.00461689336983E-12
      1.97584953199606E-18  -4.27791935621719E-03  -2.39285829922439E-03   0.00000000000000E+00   3.06226495994226E-15
     -3.29141426565794E-24  -5.98303922280679E-09  -5.98303616054184E-09  -1.52083011140489E-18
      8.49128080169138E-07
      0.00000000000000E+00  -5.96090713424290E-12   0.00000000000000E+00  -2.73034111358340E-16   2.39333390588482E-24
      5.96093582234606E-09   5.96093554931195E-09  -4.56622281095684E-19  -4.11460551384422E-01  -4.11460551384424E-01
      0.00000000000000E+00   0.00000000000000E+00   9.77725173166797E-13   0.00000000000000E+00   9.77725173166797E-13
      1.98073815786190E-18  -4.27847506988930E-03  -2.40006918280288E-03   0.00000000000000E+00  -3.59270219887357E-16
     -3.37802166283235E-24  -5.96191291521489E-09  -5.96191327448511E-09  -1.52411587676621E-18
      8.54128080169137E-07
      0.00000000000000E+00  -5.92352632619944E-12   0.00000000000000E+00  -4.21511156302819E-16   2.47846383867831E-24
      5.92357135473697E-09   5.92357093322582E-09  -4.71024544208879E-19  -4.05683362882834E-01  -4.05683362882843E-01
      0.00000000000000E+00   0.00000000000000E+00   8.78463147912462E-12   0.00000000000000E+00   8.78463147912462E-12
      2.02466131525752E-18  -4.41815829124173E-03  -2.54906562797260E-03   0.00000000000000E+00  -4.97681777385624E-15
     -3.74267093097934E-24  -5.93235058788717E-09  -5.93235556470494E-09  -1.55363677104864E-18
      8.59128080169137E-07
      0.00000000000000E+00  -5.86483753912383E-12   0.00000000000000E+00  -6.95829897400145E-16   2.72977455378045E-24
      5.86480556694334E-09   5.86480487111344E-09  -5.01121624311124E-19  -3.93594817670958E-01  -3.93594817670976E-01
      0.00000000000000E+00   0.00000000000000E+00   1.79694884071647E-11   0.00000000000000E+00   1.79694884071647E-11
      2.11450875729334E-18  -4.78532724581739E-03  -2.93185722004405E-03   0.00000000000000E+00  -1.11576098331983E-14
     -4.62113267737194E-24  -5.88276320191077E-09  -5.88277435952061E-09  -1.61338713298222E-18
      8.64128080169137E-07
      0.00000000000000E+00  -5.75627705974453E-12   0.00000000000000E+00  -2.03927104953842E-15   3.24261803407863E-24
      5.75629112561414E-09   5.75628908634309E-09  -5.49036304892973E-19  -3.74190062209980E-01  -3.74190062210008E-01
      0.00000000000000E+00   0.00000000000000E+00   2.78443969722389E-11   0.00000000000000E+00   2.78443969722389E-11
      2.25373074215454E-18  -5.60187983492379E-03  -3.77949018823598E-03   0.00000000000000E+00  -1.88571738633419E-14
     -6.64121926792875E-24  -5.78411462614146E-09  -5.78413348331533E-09  -1.70469443726156E-18
      8.69128080169137E-07
      0.00000000000000E+00  -5.52069530880723E-12   0.00000000000000E+00  -2.48031752401732E-14   4.18180925737058E-24
      5.52074228620853E-09   5.52071748303329E-09  -6.15064520827121E-19  -3.46712338725925E-01  -3.46712338725963E-01
      0.00000000000000E+00   0.00000000000000E+00   3.81751851926437E-11   0.00000000000000E+00   3.81751851926437E-11
      2.44460666811776E-18  -7.44688276342611E-03  -5.69545573091446E-03   0.00000000000000E+00  -9.79125931781762E-15
     -1.15251936145501E-23  -5.55888287696661E-09  -5.55889266822594E-09  -1.82954214729064E-18
      8.74128080169137E-07
      0.00000000000000E+00  -4.96567756186214E-12   0.00000000000000E+00  -4.97660655148806E-15   5.67963416484385E-24
      4.96568222402006E-09   4.96567724741352E-09  -6.96308444279572E-19  -3.10730740367474E-01  -3.10730740367524E-01
      0.00000000000000E+00   0.00000000000000E+00   5.04131120792110E-11   0.00000000000000E+00   5.04131120792110E-11
      2.69667222851381E-18  -1.17778955831817E-02  -1.01974990406685E-02   0.00000000000000E+00  -4.90822563088985E-14
     -2.33559012399791E-23  -5.01604127723639E-09  -5.01609035949273E-09  -2.00036378423424E-18
      8.79128080169137E-07
      0.00000000000000E+00  -3.79245288877319E-12   0.00000000000000E+00  -1.21690459124425E-14   6.96322117585128E-24
      3.79248751346122E-09   3.79247534441531E-09  -7.87512967178129E-19  -2.66351508327569E-01  -2.66351508327636E-01
      0.00000000000000E+00   0.00000000000000E+00   6.67441731772488E-11   0.00000000000000E+00   6.67441731772488E-11
      3.03039309440006E-18  -2.13887531399440E-02  -2.01728516122127E-02   0.00000000000000E+00  -7.20365292323711E-14
     -4.65270660209320E-23  -3.85914748106327E-09  -3.85921951759255E-09  -2.24288012722193E-18
      8.84128080169137E-07
      0.00000000000000E+00  -2.11858255316602E-12   0.00000000000000E+00  -1.72896038349942E-14   3.61650862616951E-24
      2.11861623348154E-09   2.11859894387771E-09  -8.86226185186208E-19  -2.14766293051214E-01  -2.14766293051296E-01
      0.00000000000000E+00   0.00000000000000E+00   8.26749700376270E-11   0.00000000000000E+00   8.26749700376270E-11
      3.44376794458819E-18  -3.84029452848420E-02  -3.77094071702544E-02   0.00000000000000E+00  -1.09880070451917E-13
     -7.28385144131217E-23  -2.20116403384481E-09  -2.20127391391534E-09  -2.55754175940199E-18
      8.89128080169137E-07
      0.00000000000000E+00  -8.26970013816571E-13   0.00000000000000E+00  -7.30868049934334E-15  -8.93688725197514E-24
      8.26997133664550E-10   8.26989824984042E-10  -9.94158439773477E-19  -1.58613635765960E-01  -1.58613635766048E-01
      0.00000000000000E+00   0.00000000000000E+00   8.84729464773439E-11   0.00000000000000E+00   8.84729464773439E-11
      3.88613267697491E-18  -6.06999839483641E-02  -6.04115606082993E-02   0.00000000000000E+00  -1.73830892724978E-13
     -8.70888743977671E-23  -9.15288940568574E-10  -9.15462771461386E-10  -2.89197423720144E-18
      8.94128080169137E-07
      0.00000000000000E+00  -2.43480398337153E-13   0.00000000000000E+00  -7.12530771435466E-15  -2.48451874510196E-23
      2.43485475379945E-10   2.43478350072206E-10  -1.11054404710453E-18  -1.01532521444724E-01  -1.01532521444807E-01
      0.00000000000000E+00   0.00000000000000E+00   8.28769069900850E-11   0.00000000000000E+00   8.28769069900850E-11
      4.30051721192534E-18  -8.47216914300112E-02  -8.46188709208081E-02   0.00000000000000E+00  -2.40356455391468E-13
     -9.38127658015237E-23  -3.26114900606806E-10  -3.26355257062291E-10  -3.18997316482080E-18
      8.99128080169137E-07
      0.00000000000000E+00  -6.81487950079849E-14   0.00000000000000E+00  -2.99142735014573E-15  -3.41325634783527E-23
      6.81887609647581E-11   6.81857695373738E-11  -1.21531449052703E-18  -5.27486074298504E-02  -5.27486074299165E-02
      0.00000000000000E+00   0.00000000000000E+00   6.60781302977484E-11   0.00000000000000E+00   6.60781302977484E-11
      4.63090786341408E-18  -1.08501126221448E-01  -1.08458825731789E-01   0.00000000000000E+00  -2.90988719861499E-13
     -9.96606819076280E-23  -1.33972911115161E-10  -1.34263899835122E-10  -3.41559337288705E-18
      9.04128080169137E-07
      0.00000000000000E+00  -3.81155659411236E-14   0.00000000000000E+00  -1.03561071144113E-15  -3.37946424899441E-23
      3.81353333869975E-11   3.81342977762523E-11  -1.27704417545416E-18  -2.49879163306759E-02  -2.49879163307171E-02
      0.00000000000000E+00   0.00000000000000E+00   4.11203486620096E-11   0.00000000000000E+00   4.11203486620096E-11
      4.83650960672413E-18  -1.31397440417383E-01  -1.31372471026496E-01   0.00000000000000E+00  -2.46332445628621E-13
     -1.04077032985497E-22  -7.90083139925290E-11  -7.92546464382617E-11  -3.55946543126997E-18
      9.09128080169137E-07
      0.00000000000000E+00  -3.89421685759913E-14   0.00000000000000E+00  -2.42348771781853E-16  -2.51631375457576E-23
      3.89146076739073E-11   3.89143653251104E-11  -1.30309754034576E-18  -1.36120502564107E-02  -1.36120502564336E-02
      0.00000000000000E+00   0.00000000000000E+00   2.29220220710651E-11   0.00000000000000E+00   2.29220220710651E-11
      4.95111971707945E-18  -1.53272754177111E-01  -1.53253272626477E-01   0.00000000000000E+00  -1.81614707489005E-13
     -1.07012749405328E-22  -6.16547726885794E-11  -6.18363873961754E-11  -3.64802217673369E-18
      9.14128080169137E-07
      0.00000000000000E+00  -4.30751817503300E-14   0.00000000000000E+00  -1.46971640400981E-17  -8.12884285941657E-24
      4.30552945907158E-11   4.30552798935436E-11  -1.31249176442358E-18  -9.30109614114923E-03  -9.30109614116324E-03
      0.00000000000000E+00   0.00000000000000E+00   1.40114001724533E-11   0.00000000000000E+00   1.40114001724533E-11
      5.02117671794172E-18  -1.74115589332525E-01  -1.74097610621036E-01   0.00000000000000E+00  -1.50618415870625E-13
     -1.09280680074331E-22  -5.69160616500173E-11  -5.70666800659972E-11  -3.70868495351814E-18
      9.19128080169137E-07
      0.00000000000000E+00  -4.66571265014236E-14   0.00000000000000E+00   2.88538458769552E-17   1.43894923200622E-23
      4.66135396779710E-11   4.66135685318312E-11  -1.31563728652961E-18  -7.41172974656676E-03  -7.41172974657685E-03
      0.00000000000000E+00   0.00000000000000E+00   1.00885397649499E-11   0.00000000000000E+00   1.00885397649499E-11
      5.07161941676647E-18  -1.93955667205577E-01  -1.93937803472585E-01   0.00000000000000E+00  -1.39662474201224E-13
     -1.11272717228909E-22  -5.65624458224684E-11  -5.67021082967809E-11  -3.75598213023685E-18
      9.24128080169137E-07
      0.00000000000000E+00  -4.95961580920644E-14   0.00000000000000E+00   3.28393660064142E-17   3.59186174409551E-23
      4.96050634494169E-11   4.96050962888189E-11  -1.31654419642204E-18  -6.35397034761148E-03  -6.35397034761974E-03
      0.00000000000000E+00   0.00000000000000E+00   8.25220390999741E-12   0.00000000000000E+00   8.25220390999741E-12
      5.11288043631645E-18  -2.12835954165904E-01  -2.12817726608323E-01   0.00000000000000E+00  -1.34561328906157E-13
     -1.13103552250483E-22  -5.77227388697968E-11  -5.78573001988161E-11  -3.79633623989442E-18
      9.29128080169137E-07
      0.00000000000000E+00  -5.23515002082902E-14   0.00000000000000E+00   3.30051648405944E-17   5.30043482128471E-23
      5.23714410844538E-11   5.23714740896716E-11  -1.31657057863319E-18  -5.64789724761403E-03  -5.64789724762129E-03
      0.00000000000000E+00   0.00000000000000E+00   7.25448048957367E-12   0.00000000000000E+00   7.25448048957367E-12
      5.14915283876433E-18  -2.30801705948205E-01  -2.30782921299873E-01   0.00000000000000E+00  -1.30319847696354E-13
     -1.14807062618401E-22  -5.94956347314343E-11  -5.96259545792455E-11  -3.83258226013113E-18
      9.34128080169137E-07
      0.00000000000000E+00  -5.51068423245161E-14   0.00000000000000E+00   3.44679958428038E-17   6.50684034467560E-23
      5.51027753756612E-11   5.51028098437221E-11  -1.31617652127574E-18  -5.13874225785868E-03  -5.13874225786530E-03
      0.00000000000000E+00   0.00000000000000E+00   6.61497920016376E-12   0.00000000000000E+00   6.61497920016376E-12
      5.18222773476514E-18  -2.47895688573495E-01  -2.47876245023758E-01   0.00000000000000E+00  -1.25956753616081E-13
     -1.16403460895182E-22  -6.15918322901536E-11  -6.17177890438861E-11  -3.86605121348940E-18
      9.39128080169137E-07
      0.00000000000000E+00  -5.78621844407419E-14   0.00000000000000E+00   3.66697823540993E-17   7.31770292030339E-23
      5.78696256661793E-11   5.78696623360349E-11  -1.31553378036547E-18  -4.76467339346546E-03  -4.76467339347160E-03
      0.00000000000000E+00   0.00000000000000E+00   6.14089679272725E-12   0.00000000000000E+00   6.14089679272725E-12
      5.21293221872878E-18  -2.64154559227431E-01  -2.64134393478906E-01   0.00000000000000E+00  -1.21486250988352E-13
     -1.17909283821802E-22  -6.38890728776555E-11  -6.40105591287617E-11  -3.89739843836331E-18
      9.44128080169137E-07
      0.00000000000000E+00  -6.07093712941752E-14   0.00000000000000E+00   3.90235198995352E-17   7.87008991577554E-23
      6.06914519160003E-11   6.06914909395989E-11  -1.31471414687656E-18  -4.49617046329064E-03  -4.49617046329639E-03
      0.00000000000000E+00   0.00000000000000E+00   5.74734210052805E-12   0.00000000000000E+00   5.74734210052805E-12
      5.24166892923142E-18  -2.79611963738620E-01  -2.79591033107384E-01   0.00000000000000E+00  -1.17053308739621E-13
     -1.19336697612326E-22  -6.63217797312685E-11  -6.64388330401275E-11  -3.92695478235486E-18
      9.49128080169137E-07
      0.00000000000000E+00  -6.35565581476085E-14   0.00000000000000E+00   4.14715079358717E-17   8.27004790266189E-23
      6.35788929351532E-11   6.35789344067438E-11  -1.31374574338938E-18  -4.31960225102985E-03  -4.31960225103524E-03
      0.00000000000000E+00   0.00000000000000E+00   5.39680502293460E-12   0.00000000000000E+00   5.39680502293460E-12
      5.26865295434609E-18  -2.94311019231784E-01  -2.94289289498800E-01   0.00000000000000E+00  -1.12836938233751E-13
     -1.20694852746762E-22  -6.88629024913233E-11  -6.89757394296777E-11  -3.95490721095671E-18
      9.54128080169136E-07
      0.00000000000000E+00  -6.65874344754569E-14   0.00000000000000E+00   4.43369979498115E-17   8.58537307814801E-23
      6.65548671401945E-11   6.65549114772783E-11  -1.31262742118330E-18  -4.23337954964604E-03  -4.23337954965110E-03
      0.00000000000000E+00   0.00000000000000E+00   5.07038806018987E-12   0.00000000000000E+00   5.07038806018987E-12
      5.29400489464704E-18  -3.08305977890377E-01  -3.08283413569548E-01   0.00000000000000E+00  -1.08951383442503E-13
     -1.21991328428653E-22  -7.15163481539039E-11  -7.16252995374684E-11  -3.98137747346374E-18
      9.59128080169136E-07
      0.00000000000000E+00  -6.97101555405128E-14   0.00000000000000E+00   4.83929908099169E-17   8.85716552575740E-23
      6.96763875488965E-11   6.96764359419758E-11  -1.31132250507077E-18  -4.25063080712477E-03  -4.25063080712953E-03
      0.00000000000000E+00   0.00000000000000E+00   4.75862452213858E-12   0.00000000000000E+00   4.75862452213858E-12
      5.31779801725773E-18  -3.21675263306706E-01  -3.21651813933195E-01   0.00000000000000E+00  -1.05546465678187E-13
     -1.23233835606608E-22  -7.43295139983131E-11  -7.44350604641145E-11  -4.00647551218697E-18
      9.64128080169136E-07
      0.00000000000000E+00  -7.30165660799838E-14   0.00000000000000E+00   5.49395577567655E-17   9.11128746225954E-23
      7.30517914786668E-11   7.30518464183157E-11  -1.30973862249724E-18  -4.41053316500279E-03  -4.41053316500720E-03
      0.00000000000000E+00   0.00000000000000E+00   4.42048382826490E-12   0.00000000000000E+00   4.42048382826490E-12
      5.33990043639906E-18  -3.34445266785059E-01  -3.34420860691022E-01   0.00000000000000E+00  -1.01939945867739E-13
     -1.24421309667939E-22  -7.73703903005887E-11  -7.74723302465809E-11  -4.03016181390182E-18
      9.69128080169136E-07
      0.00000000000000E+00  -7.69658897799074E-14   0.00000000000000E+00   6.74018527494936E-17   9.37165233924802E-23
      7.69374255766027E-11   7.69374929785492E-11  -1.30765198469853E-18  -4.81034611648341E-03  -4.81034611648741E-03
      0.00000000000000E+00   0.00000000000000E+00   3.99774784896941E-12   0.00000000000000E+00   3.99774784896941E-12
      5.35988917564390E-18  -3.46615502737635E-01  -3.46590005839045E-01   0.00000000000000E+00  -9.73455287249884E-14
     -1.25543521905229E-22  -8.08378952986681E-11  -8.09352408275186E-11  -4.05223719094537E-18
      9.74128080169136E-07
      0.00000000000000E+00  -8.20173503263214E-14   0.00000000000000E+00   9.58334633445920E-17   9.67943924805503E-23
      8.20131311957781E-11   8.20132270293383E-11  -1.30449627187917E-18  -5.69537485360019E-03  -5.69537485360356E-03
      0.00000000000000E+00   0.00000000000000E+00   3.37064776283976E-12   0.00000000000000E+00   3.37064776283976E-12
      5.37674241445811E-18  -3.58195410298997E-01  -3.58168512072271E-01   0.00000000000000E+00  -9.04221551924478E-14
     -1.26575089548737E-22  -8.52934526368589E-11  -8.53838747921779E-11  -4.07224614257893E-18
      9.79128080169136E-07
      0.00000000000000E+00  -9.01915319377913E-14   0.00000000000000E+00   1.67796733845371E-16   1.01339857302595E-22
      9.02099934339828E-11   9.02101612308180E-11  -1.29878087200782E-18  -7.70902244473831E-03  -7.70902244474052E-03
      0.00000000000000E+00   0.00000000000000E+00   2.20787029648057E-12   0.00000000000000E+00   2.20787029648057E-12
      5.38778176594051E-18  -3.69195642805913E-01  -3.69166528752887E-01   0.00000000000000E+00  -7.72690098248078E-14
     -1.27446771509913E-22  -9.23407625173458E-11  -9.24180315272981E-11  -4.08900089393269E-18
      9.84128080169136E-07
      0.00000000000000E+00  -1.07182808321184E-13   0.00000000000000E+00   3.41403626044798E-16   1.09730808874605E-22
      1.07194137007396E-10   1.07194478411132E-10  -1.28675234714649E-18  -1.24531383775114E-02  -1.24531383775111E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.13618466818768E-13   0.00000000000000E+00  -3.13618466818768E-13
      5.38621367360641E-18  -3.79606808844064E-01  -3.79573138753813E-01   0.00000000000000E+00  -4.83402804931406E-14
     -1.27982574149701E-22  -1.06832519663692E-10  -1.06880859944314E-10  -4.09946132645992E-18
      9.89128080169136E-07
      0.00000000000000E+00  -1.48237405852948E-13   0.00000000000000E+00   7.55810337958985E-16   1.25558172734467E-22
      1.48191421352110E-10   1.48192177162574E-10  -1.26135072192320E-18  -2.28407561401561E-02  -2.28407561401506E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.44419648663517E-12   0.00000000000000E+00  -5.44419648663517E-12
      5.35899269117324E-18  -3.89354948292051E-01  -3.89309979271760E-01   0.00000000000000E+00   8.49371196895725E-15
     -1.27870007338366E-22  -1.42756474387779E-10  -1.42747980675938E-10  -4.09764196925004E-18
      9.94128080169136E-07
      0.00000000000000E+00  -2.44307000972021E-13   0.00000000000000E+00   1.49841888924581E-15   1.47665000356933E-22
      2.44295716995354E-10   2.44297215414391E-10  -1.21767459606480E-18  -4.06414981521325E-02  -4.06414981521198E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.26845340012666E-11   0.00000000000000E+00  -1.26845340012666E-11
      5.29557002116690E-18  -3.98220653920528E-01  -3.98147690260714E-01   0.00000000000000E+00   7.82086988165881E-14
     -1.26961611323504E-22  -2.31690890111814E-10  -2.31612681413125E-10  -4.07789542510210E-18
      9.99128080169136E-07
      0.00000000000000E+00  -4.40671049121713E-13   0.00000000000000E+00   2.24966139129760E-15   1.67492893389229E-22
      4.40667319109888E-10   4.40669568771447E-10  -1.16166211270853E-18  -6.33047413436025E-02  -6.33047413435838E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.87051057958177E-11   0.00000000000000E+00  -1.87051057958177E-11
      5.20204449218781E-18  -4.05765965997383E-01  -4.05633036078530E-01   0.00000000000000E+00   1.18722039031302E-13
     -1.25584798596774E-22  -4.22083185014535E-10  -4.21964462975630E-10  -4.04038237947929E-18
      1.00412808016914E-06
      0.00000000000000E+00  -7.95099890005559E-13   0.00000000000000E+00   4.13558583481682E-15   1.81817770391497E-22
      7.95092546558275E-10   7.95096682144292E-10  -1.10326866884992E-18  -8.73748073586570E-02  -8.73748073586345E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.24437384853245E-11   0.00000000000000E+00  -2.24437384853245E-11
      5.08982579976119E-18  -4.11295753542365E-01  -4.11052346233494E-01   0.00000000000000E+00   1.28537388778269E-13
     -1.24062061967660E-22  -7.72781481047621E-10  -7.72652943658967E-10  -3.98655713091128E-18
      1.00912808016914E-06
      0.00000000000000E+00  -1.37050716861071E-12   0.00000000000000E+00   6.20698725505295E-15   1.92581488517575E-22
      1.37045894292025E-09   1.37046514990770E-09  -1.04858097817653E-18  -1.11075970491138E-01  -1.11075970491113E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.51403204342029E-11   0.00000000000000E+00  -2.51403204342029E-11
      4.96412419759018E-18  -4.13856544139097E-01  -4.13432726531932E-01   0.00000000000000E+00   1.31941277705364E-13
     -1.22461109517172E-22  -1.34545677075108E-09  -1.34532482947350E-09  -3.91554321941365E-18
      1.01412808016914E-06
      0.00000000000000E+00  -2.22007098778034E-12   0.00000000000000E+00   8.84431298800144E-15   2.01064984179658E-22
      2.22003287889968E-09   2.22004172321287E-09  -9.99470930471210E-19  -1.33863690995481E-01  -1.33863690995453E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.78316486108368E-11   0.00000000000000E+00  -2.78316486108368E-11
      4.82496595453600E-18  -4.12292852781784E-01  -4.11602236534985E-01   0.00000000000000E+00   1.40588684951803E-13
     -1.20707204202546E-22  -2.19235066328686E-09  -2.19221007460203E-09  -3.82549502406479E-18
      1.01912808016914E-06
      0.00000000000000E+00  -3.37116107920227E-12   0.00000000000000E+00   1.17664725814239E-14   2.07084975406994E-22
      3.37116403998311E-09   3.37117580645590E-09  -9.55737520312872E-19  -1.55624800397210E-01  -1.55624800397179E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.07082602955945E-11   0.00000000000000E+00  -3.07082602955945E-11
      4.67142465305802E-18  -4.05374440088111E-01  -4.04322078530075E-01   0.00000000000000E+00   1.58368024411850E-13
     -1.18673829321426E-22  -3.34062591418459E-09  -3.34046754616030E-09  -3.71568713274515E-18
      1.02412808016914E-06
      0.00000000000000E+00  -4.81927705075334E-12   0.00000000000000E+00   1.46378164735757E-14   2.09948023229228E-22
      4.81928258844651E-09   4.81929722626320E-09  -9.16529286271699E-19  -1.76355165088687E-01  -1.76355165088654E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.35230725796924E-11   0.00000000000000E+00  -3.35230725796924E-11
      4.50380929015956E-18  -3.91947739573832E-01  -3.90440044451686E-01   0.00000000000000E+00   1.85974456208842E-13
     -1.16213715161327E-22  -4.78596012813960E-09  -4.78577415368351E-09  -3.58728000388786E-18
      1.02912808016914E-06
      0.00000000000000E+00  -6.53521227600157E-12   0.00000000000000E+00   1.72382789777006E-14   2.09209836099387E-22
      6.53517613142321E-09   6.53519336970239E-09  -8.80928135907263E-19  -1.96087068395512E-01  -1.96087068395476E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.59879727076194E-11   0.00000000000000E+00  -3.59879727076194E-11
      4.32386942662146E-18  -3.71048549009396E-01  -3.69001039651681E-01   0.00000000000000E+00   2.21966193699668E-13
     -1.13173112098693E-22  -6.49942736318837E-09  -6.49920539699478E-09  -3.44294129071420E-18
      1.03412808016914E-06
      0.00000000000000E+00  -8.47377914424083E-12   0.00000000000000E+00   1.94027718202884E-14   2.05147151525640E-22
      8.47377045641125E-09   8.47378985918327E-09  -8.48154835617389E-19  -2.14864147287510E-01  -2.14864147287472E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.79256514625609E-11   0.00000000000000E+00  -3.79256514625609E-11
      4.13424116930866E-18  -3.41972130261945E-01  -3.39314464642926E-01   0.00000000000000E+00   2.62034317549991E-13
     -1.09403189985184E-22  -8.43612624203816E-09  -8.43586420772072E-09  -3.28608633369127E-18
      1.03912808016914E-06
      0.00000000000000E+00  -1.05711455631119E-11   0.00000000000000E+00   2.09433383973492E-14   1.98842588094222E-22
      1.05711080034411E-08   1.05711289467797E-08  -8.17621894061037E-19  -2.32731596607280E-01  -2.32731596607241E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.93600204801050E-11   0.00000000000000E+00  -3.93600204801050E-11
      3.93744106690813E-18  -3.04360626475088E-01  -3.01042614071312E-01   0.00000000000000E+00   2.96525460044691E-13
     -1.04754758946404E-22  -1.05320654517596E-08  -1.05317689262996E-08  -3.11981917284710E-18
      1.04412808016914E-06
      0.00000000000000E+00  -1.27065357031869E-11   0.00000000000000E+00   2.12984261614154E-14   1.90818390349893E-22
      1.27065463764696E-08   1.27065676748960E-08  -7.88980984316964E-19  -2.49731692225225E-01  -2.49731692225184E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.07090800366548E-11   0.00000000000000E+00  -4.07090800366548E-11
      3.73389566672486E-18  -2.58458139580620E-01  -2.54467727915290E-01   0.00000000000000E+00   3.07771836629515E-13
     -9.90601262717101E-23  -1.26661663666959E-08  -1.26658585948593E-08  -2.94491468240789E-18
      1.04912808016914E-06
      0.00000000000000E+00  -1.46192023555337E-11   0.00000000000000E+00   1.90804745539724E-14   1.76787473237522E-22
      1.46191832819721E-08   1.46192023624469E-08  -7.62205503587366E-19  -2.65900322552603E-01  -2.65900322552560E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.30042655042599E-11   0.00000000000000E+00  -4.30042655042599E-11
      3.51887433920356E-18  -2.05715158296919E-01  -2.01122826277199E-01   0.00000000000000E+00   2.77052758612911E-13
     -9.24772921659084E-23  -1.45764751497011E-08  -1.45761980969426E-08  -2.75666883561619E-18
      1.05412808016914E-06
      0.00000000000000E+00  -1.59965060346977E-11   0.00000000000000E+00   1.37773477665238E-14   1.48739590718712E-22
      1.59964780064245E-08   1.59964917837725E-08  -7.37338368300338E-19  -2.81271715980300E-01  -2.81271715980253E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.62958004337050E-11   0.00000000000000E+00  -4.62958004337050E-11
      3.28739533703504E-18  -1.48958623935233E-01  -1.43933350621440E-01   0.00000000000000E+00   2.16067405621899E-13
     -8.63698873492942E-23  -1.59504120507443E-08  -1.59501959833387E-08  -2.55005696873470E-18
      1.05912808016914E-06
      0.00000000000000E+00  -1.65554731053427E-11   0.00000000000000E+00   5.68600494941437E-15   1.06553523776807E-22
      1.65554958966190E-08   1.65555015826241E-08  -7.14111118072437E-19  -2.95889837861103E-01  -2.95889837861055E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.82200464792246E-11   0.00000000000000E+00  -4.82200464792246E-11
      3.04629510463891E-18  -9.22166422525697E-02  -8.70158112758572E-02   0.00000000000000E+00   1.64293249747765E-13
     -7.89687445683956E-23  -1.65074458293945E-08  -1.65072815361448E-08  -2.33218398656648E-18
      1.06412808016914E-06
      0.00000000000000E+00  -1.48060145510138E-11   0.00000000000000E+00   1.70987008640488E-13   5.55577553891950E-23
      1.48060801011196E-08   1.48062510881283E-08  -6.91619507135326E-19  -3.09811997885985E-01  -3.09811997885939E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.55264002077834E-11   0.00000000000000E+00  -4.55264002077834E-11
      2.81866310360000E-18  -4.64042448541634E-02  -4.17537231493887E-02   0.00000000000000E+00  -6.34085813808551E-14
     -5.22279222827128E-23  -1.47606612793391E-08  -1.47607246879205E-08  -2.12704359646467E-18
      1.06912808016914E-06
      0.00000000000000E+00  -1.06966973188746E-11   0.00000000000000E+00  -4.03921709754678E-14   2.45733094436477E-23
      1.06967665444839E-08   1.06967261523130E-08  -6.66653519332747E-19  -3.23114931387669E-01  -3.23114931387636E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.35122564274713E-11   0.00000000000000E+00  -3.35122564274713E-11
      2.65110182146264E-18  -2.21662974254354E-02  -1.88066863919345E-02   0.00000000000000E+00   9.65117914018799E-14
     -2.44802842192136E-23  -1.06633104076769E-08  -1.06632138958855E-08  -1.98444830212989E-18
      1.07412808016914E-06
      0.00000000000000E+00  -7.84234657593909E-12   0.00000000000000E+00  -2.79961932305652E-14   1.25264661040769E-23
      7.84234324549092E-09   7.84231524929770E-09  -6.39465482539410E-19  -3.35818599723566E-01  -3.35818599723543E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.32596605853802E-11   0.00000000000000E+00  -2.32596605853802E-11
      2.53480351853574E-18  -1.25479389429970E-02  -1.00844201658557E-02   0.00000000000000E+00   5.74929789617760E-14
     -1.30840266483433E-23  -7.81911308169127E-09  -7.81905558871232E-09  -1.89533803599633E-18
      1.07912808016914E-06
      0.00000000000000E+00  -6.67922482394297E-12   0.00000000000000E+00  -1.13205284115553E-14   8.00251648545441E-24
      6.67922756383903E-09   6.67921624331062E-09  -6.11835974446101E-19  -3.47923067156427E-01  -3.47923067156409E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.85246283989542E-11   0.00000000000000E+00  -1.85246283989542E-11
      2.44218037654097E-18  -8.86664573510648E-03  -6.76808581486729E-03   0.00000000000000E+00   3.09587046322530E-14
     -8.95614397913087E-24  -6.66072257361630E-09  -6.66069161491167E-09  -1.83034440209487E-18
      1.08412808016914E-06
      0.00000000000000E+00  -6.29017051713188E-12   0.00000000000000E+00  -3.69938241203980E-15   5.94070355604001E-24
      6.29017609882524E-09   6.29017239944283E-09  -5.84647592122282E-19  -3.59438664955422E-01  -3.59438664955405E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.65266914724649E-11   0.00000000000000E+00  -1.65266914724649E-11
      2.35954691917864E-18  -7.18744133898577E-03  -5.21082484827463E-03   0.00000000000000E+00   1.93558071282372E-14
     -6.99941818381106E-24  -6.27366506377749E-09  -6.27364570797037E-09  -1.77489932705636E-18
      1.08912808016914E-06
      0.00000000000000E+00  -6.15672011396935E-12   0.00000000000000E+00  -1.63546888913127E-15   4.74167029775995E-24
      6.15670996046225E-09   6.15670832499336E-09  -5.58269480596636E-19  -3.70375152338909E-01  -3.70375152338894E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.54859093005453E-11   0.00000000000000E+00  -1.54859093005453E-11
      2.28211737267592E-18  -6.21099513529579E-03  -4.27609921604495E-03   0.00000000000000E+00   1.50697952661033E-14
     -5.78386441654469E-24  -6.14123748548809E-09  -6.14122241569283E-09  -1.72384789207928E-18
      1.09412808016914E-06
      0.00000000000000E+00  -6.09931715321464E-12   0.00000000000000E+00  -4.53817282284822E-16   3.93947663985811E-24
      6.09930698075766E-09   6.09930652694038E-09  -5.32956022297554E-19  -3.80719033893126E-01  -3.80719033893112E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.47404954574263E-11   0.00000000000000E+00  -1.47404954574263E-11
      2.20841489538878E-18  -5.54648592418071E-03  -3.62943943064355E-03   0.00000000000000E+00   1.22424541443178E-14
     -4.92420253732039E-24  -6.08457827393710E-09  -6.08456603148296E-09  -1.67545887309123E-18
      1.09912808016914E-06
      0.00000000000000E+00  -6.06634489255714E-12   0.00000000000000E+00  -2.25033177116834E-16   3.36765842957488E-24
      6.06634953064803E-09   6.06634930561486E-09  -5.09074477844925E-19  -3.90385154719999E-01  -3.90385154719985E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.39829140671262E-11   0.00000000000000E+00  -1.39829140671262E-11
      2.13850032505315E-18  -5.06408541520436E-03  -3.15718286749809E-03   0.00000000000000E+00   1.05406315178300E-14
     -4.28142819534677E-24  -6.05237693217925E-09  -6.05236639154774E-09  -1.62942584720823E-18
      1.10412808016914E-06
      0.00000000000000E+00  -6.04274079509481E-12   0.00000000000000E+00  -1.45941558111510E-16   2.95379047167407E-24
      6.04271048177684E-09   6.04271033583528E-09  -4.87338614895277E-19  -3.99133608618600E-01  -3.99133608618587E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.28949257823064E-11   0.00000000000000E+00  -1.28949257823064E-11
      2.07402569614162E-18  -4.70987032268691E-03  -2.81007191587733E-03   0.00000000000000E+00   8.94804735882082E-15
     -3.80497743710827E-24  -6.02982435810033E-09  -6.02981541005298E-09  -1.58668708124634E-18
      1.10912808016914E-06
      0.00000000000000E+00  -6.02262679764636E-12   0.00000000000000E+00  -1.95849867244014E-16   2.65955473231906E-24
      6.02261095721903E-09   6.02261076136916E-09  -4.68987583642413E-19  -4.06500353383157E-01  -4.06500353383146E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10680779633975E-11   0.00000000000000E+00  -1.10680779633975E-11
      2.01868530632463E-18  -4.45770585993969E-03  -2.56366382248719E-03   0.00000000000000E+00   7.23538694854089E-15
     -3.47129134704750E-24  -6.01154991879271E-09  -6.01154268340577E-09  -1.54969772268222E-18
      1.11412808016913E-06
      0.00000000000000E+00  -6.00269648967233E-12   0.00000000000000E+00  -9.34086445367440E-17   2.46542277319558E-24
      6.00274173327885E-09   6.00274163987021E-09  -4.55871632628026E-19  -4.11761913158614E-01  -4.11761913158606E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.03605820690929E-12   0.00000000000000E+00  -8.03605820690929E-12
      1.97850501529009E-18  -4.29608169339771E-03  -2.40734400845638E-03   0.00000000000000E+00   4.91578745229716E-15
     -3.27452809898275E-24  -5.99471049745074E-09  -5.99470558166330E-09  -1.52263338266206E-18
      1.11912808016913E-06
      0.00000000000000E+00  -5.98028637379369E-12   0.00000000000000E+00  -2.02156844916651E-16   2.36504028155975E-24
      5.98024861082564E-09   5.98024840866880E-09  -4.50443796507628E-19  -4.13939454311878E-01  -4.13939454311875E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.36406134394023E-12   0.00000000000000E+00  -3.36406134394023E-12
      1.96168470857039E-18  -4.22548000373035E-03  -2.34235698755097E-03   0.00000000000000E+00   2.12360948436483E-15
     -3.22831466198118E-24  -5.97688647093434E-09  -5.97688434732486E-09  -1.51124091206276E-18
      1.12412808016913E-06
      0.00000000000000E+00  -5.95153897104773E-12   0.00000000000000E+00  -3.01477280635018E-16   2.36524935606389E-24
      5.95156328038078E-09   5.95156297890350E-09  -4.55620475160470E-19  -4.11862361224451E-01  -4.11862361224454E-01
      0.00000000000000E+00   0.00000000000000E+00   3.18999613348669E-12   0.00000000000000E+00   3.18999613348669E-12
      1.97763468923782E-18  -4.26214137097348E-03  -2.38599142277423E-03   0.00000000000000E+00  -1.62222658500665E-15
     -3.37936623917777E-24  -5.95475135281040E-09  -5.95475297503699E-09  -1.52201421407735E-18
      1.12912808016913E-06
      0.00000000000000E+00  -5.91048437351597E-12   0.00000000000000E+00  -4.74679279625597E-16   2.49148388728687E-24
      5.91048825896905E-09   5.91048778428977E-09  -4.74468546998351E-19  -4.04301681976546E-01  -4.04301681976558E-01
      0.00000000000000E+00   0.00000000000000E+00   1.14845147679357E-11   0.00000000000000E+00   1.14845147679357E-11
      2.03505726307750E-18  -4.45150288099900E-03  -2.58568178272672E-03   0.00000000000000E+00  -6.59452745665227E-15
     -3.84628031276791E-24  -5.92196570453025E-09  -5.92197229905771E-09  -1.56058871607915E-18
      1.13412808016913E-06
      0.00000000000000E+00  -5.84297849166844E-12   0.00000000000000E+00  -8.03526708055961E-16   2.80117162378418E-24
      5.84301867142894E-09   5.84301786790223E-09  -5.09750187929622E-19  -3.90119586592765E-01  -3.90119586592785E-01
      0.00000000000000E+00   0.00000000000000E+00   2.09575011511273E-11   0.00000000000000E+00   2.09575011511273E-11
      2.13984476883314E-18  -4.90590907487198E-03  -3.05836235873636E-03   0.00000000000000E+00  -1.32972818190598E-14
     -4.93189921310342E-24  -5.86396207177153E-09  -5.86397536905335E-09  -1.63009458090351E-18
      1.13912808016913E-06
      0.00000000000000E+00  -5.71219158588492E-12   0.00000000000000E+00  -1.52137961439525E-15   3.40734542709879E-24
      5.71221625801735E-09   5.71221473663773E-09  -5.63225187539222E-19  -3.68376601021470E-01  -3.68376601021501E-01
      0.00000000000000E+00   0.00000000000000E+00   3.09321155001398E-11   0.00000000000000E+00   3.09321155001398E-11
      2.29450534633383E-18  -5.91080703590014E-03  -4.10133183815006E-03   0.00000000000000E+00  -2.25586941579706E-14
     -7.45748471575807E-24  -5.74312429344372E-09  -5.74314685213788E-09  -1.73128015879461E-18
      1.14412808016913E-06
      0.00000000000000E+00  -5.41718628997434E-12   0.00000000000000E+00  -6.10245469241741E-15   4.48805927100143E-24
      5.41721155793817E-09   5.41720545548349E-09  -6.34427182787716E-19  -3.38399484318778E-01  -3.38399484318819E-01
      0.00000000000000E+00   0.00000000000000E+00   4.15016490658038E-11   0.00000000000000E+00   4.15016490658038E-11
      2.50201359166285E-18  -8.21609205667871E-03  -6.49623715485205E-03   0.00000000000000E+00  -3.27450122657309E-14
     -1.36619241486008E-23  -5.45867435953701E-09  -5.45870710454929E-09  -1.86758640887514E-18
      1.14912808016913E-06
      0.00000000000000E+00  -4.72320745563427E-12   0.00000000000000E+00  -7.36026540968409E-15   6.08194905570921E-24
      4.72320767293951E-09   4.72320031267411E-09  -7.19477222452654E-19  -2.99877253509148E-01  -2.99877253509203E-01
      0.00000000000000E+00   0.00000000000000E+00   5.46895379909974E-11   0.00000000000000E+00   5.46895379909974E-11
      2.77546128161784E-18  -1.36399986449741E-02  -1.21346520230710E-02   0.00000000000000E+00  -5.38727124861798E-14
     -2.83313103089774E-23  -4.77783597795259E-09  -4.77788985066510E-09  -2.05598405916519E-18
      1.15412808016913E-06
      0.00000000000000E+00  -3.35912941862808E-12   0.00000000000000E+00  -1.41268717175336E-14   6.72756903963540E-24
      3.35909362762200E-09   3.35907950075029E-09  -8.13221118745046E-19  -2.53147608492230E-01  -2.53147608492301E-01
      0.00000000000000E+00   0.00000000000000E+00   7.18211329748214E-11   0.00000000000000E+00   7.18211329748214E-11
      3.13456694649195E-18  -2.51931940491753E-02  -2.41122419907788E-02   0.00000000000000E+00  -8.07287848361314E-14
     -5.40876948195198E-23  -3.43081990494022E-09  -3.43090063372511E-09  -2.32134582774690E-18
      1.15912808016913E-06
      0.00000000000000E+00  -1.69297404094634E-12   0.00000000000000E+00  -2.77333546772864E-14   6.28942618216926E-25
      1.69297350353425E-09   1.69294577017957E-09  -9.14592657441267E-19  -1.99825662491503E-01  -1.99825662491589E-01
      0.00000000000000E+00   0.00000000000000E+00   8.57461139982283E-11   0.00000000000000E+00   8.57461139982283E-11
      3.56329751648309E-18  -4.40291985970931E-02  -4.34687979283832E-02   0.00000000000000E+00  -1.13517626763991E-13
     -6.47463879699837E-23  -1.77857836655097E-09  -1.77869188417779E-09  -2.64870485904182E-18
      1.16412808016913E-06
      0.00000000000000E+00  -6.04705749774356E-13   0.00000000000000E+00  -1.18439370530840E-14  -1.35545920823710E-23
      6.04698707801409E-10   6.04686863864342E-10  -1.02559712237349E-18  -1.42833811007581E-01  -1.42833811007670E-01
      0.00000000000000E+00   0.00000000000000E+00   8.81841325660981E-11   0.00000000000000E+00   8.81841325660981E-11
      4.00421817931358E-18  -6.71120724901009E-02  -6.68937773190024E-02   0.00000000000000E+00  -1.86471967231230E-13
     -8.92300087808331E-23  -6.92684524463120E-10  -6.92870996430440E-10  -2.97862105694009E-18
      1.16912808016913E-06
      0.00000000000000E+00  -1.67800334878151E-13   0.00000000000000E+00  -5.61999357581126E-15  -2.84987337877049E-23
      1.67774721060412E-10   1.67769101066807E-10  -1.14239941907359E-18  -8.65264168481403E-02  -8.65264168482200E-02
      0.00000000000000E+00   0.00000000000000E+00   7.96405754108039E-11   0.00000000000000E+00   7.96405754108039E-11
      4.40242105636760E-18  -9.12004567010355E-02  -9.11225087380146E-02   0.00000000000000E+00  -2.60906186265602E-13
     -9.54612842214449E-23  -2.47148770291250E-10  -2.47409676477611E-10  -3.26002163729401E-18
      1.17412808016913E-06
      0.00000000000000E+00  -5.25351896827053E-14   0.00000000000000E+00  -2.29774275420550E-15  -3.49735024882038E-23
      5.25642059229616E-11   5.25619081801724E-11  -1.23717740449668E-18  -4.28152700354718E-02  -4.28152700355312E-02
      0.00000000000000E+00   0.00000000000000E+00   5.94377656926416E-11   0.00000000000000E+00   5.94377656926416E-11
      4.69960988483081E-18  -1.14773976702827E-01  -1.14738690719192E-01   0.00000000000000E+00  -2.87736804413202E-13
     -1.01061993803848E-22  -1.11711937068300E-10  -1.11999673872814E-10  -3.46243248033412E-18
      1.17912808016913E-06
      0.00000000000000E+00  -3.71971185690483E-14   0.00000000000000E+00  -7.23504203218458E-16  -3.23117401414057E-23
      3.72023581192616E-11   3.72016346150261E-11  -1.28698697579054E-18  -2.06417339327726E-02  -2.06417339328076E-02
      0.00000000000000E+00   0.00000000000000E+00   3.50285133805484E-11   0.00000000000000E+00   3.50285133805484E-11
      4.87475245173355E-18  -1.37401344064993E-01  -1.37378587814680E-01   0.00000000000000E+00  -2.25857023340162E-13
     -1.04986181577173E-22  -7.20042909721293E-11  -7.22301479955745E-11  -3.58776547594301E-18
      1.18412808016913E-06
      0.00000000000000E+00  -4.00443054224817E-14   0.00000000000000E+00  -1.43602537939082E-16  -2.13443599025053E-23
      4.00046180145521E-11   4.00044744119929E-11  -1.30681217051802E-18  -1.19781935750224E-02  -1.19781935750421E-02
      0.00000000000000E+00   0.00000000000000E+00   1.97085218327238E-11   0.00000000000000E+00   1.97085218327238E-11
      4.97329506089717E-18  -1.58997073762406E-01  -1.58978261229457E-01   0.00000000000000E+00  -1.69740650359795E-13
     -1.07670109383202E-22  -5.95432555942491E-11  -5.97129962447166E-11  -3.66648289037914E-18
      1.18912808016913E-06
      0.00000000000000E+00  -4.40854738596128E-14   0.00000000000000E+00   6.58157930324247E-17  -2.26613398483243E-24
      4.40836193270312E-11   4.40836851428219E-11  -1.31377803538341E-18  -8.62915610698880E-03  -8.62915610700140E-03
      0.00000000000000E+00   0.00000000000000E+00   1.25921262255910E-11   0.00000000000000E+00   1.25921262255910E-11
      5.03625569202512E-18  -1.79565676969588E-01  -1.79547821453290E-01   0.00000000000000E+00  -1.46407492877669E-13
     -1.09839492929846E-22  -5.65294038754254E-11  -5.66758113684129E-11  -3.72247765664172E-18
      1.19412808016913E-06
      0.00000000000000E+00  -4.74837291362913E-14   0.00000000000000E+00   3.15751381019650E-17   2.05618687873745E-23
      4.74527356441332E-11   4.74527672192919E-11  -1.31605583264722E-18  -7.06104977326993E-03  -7.06104977327938E-03
      0.00000000000000E+00   0.00000000000000E+00   9.44814668096142E-12   0.00000000000000E+00   9.44814668096142E-12
      5.08349642542993E-18  -1.99142375614988E-01  -1.99124449280005E-01   0.00000000000000E+00  -1.37993641547643E-13
     -1.11781688019987E-22  -5.67629202585937E-11  -5.69009139002531E-11  -3.76744059278271E-18
      1.19912808016913E-06
      0.00000000000000E+00  -5.03309159897247E-14   0.00000000000000E+00   3.29000094070155E-17   4.10903213092359E-23
      5.03551566817105E-11   5.03551895817610E-11  -1.31663428552694E-18  -6.12888277133168E-03  -6.12888277133960E-03
      0.00000000000000E+00   0.00000000000000E+00   7.92268112574328E-12   0.00000000000000E+00   7.92268112574328E-12
      5.12310983105864E-18  -2.17771489706177E-01  -2.17753129680553E-01   0.00000000000000E+00  -1.33390100846598E-13
     -1.13575578818574E-22  -5.81444806065443E-11  -5.82778707075044E-11  -3.80647554553170E-18
      1.20412808016913E-06
      0.00000000000000E+00  -5.30862581059505E-14   0.00000000000000E+00   3.33345588682721E-17   5.67657626991039E-23
      5.31003678515518E-11   5.31004011861674E-11  -1.31651282320761E-18  -5.48782890099659E-03  -5.48782890100365E-03
      0.00000000000000E+00   0.00000000000000E+00   7.05440743246039E-12   0.00000000000000E+00   7.05440743246039E-12
      5.15838186822095E-18  -2.35498003125891E-01  -2.35479051896637E-01   0.00000000000000E+00  -1.29148372775958E-13
     -1.15248157398339E-22  -6.00256602457366E-11  -6.01548086186278E-11  -3.84186904501334E-18
      1.20912808016913E-06
      0.00000000000000E+00  -5.58416002221763E-14   0.00000000000000E+00   3.50705783623217E-17   6.76119960768799E-23
      5.58382893559922E-11   5.58383244266381E-11  -1.31603648449474E-18  -5.02093291331343E-03  -5.02093291331991E-03
      0.00000000000000E+00   0.00000000000000E+00   6.47360836527582E-12   0.00000000000000E+00   6.47360836527582E-12
      5.19074991004732E-18  -2.52363378389183E-01  -2.52343747691024E-01   0.00000000000000E+00  -1.24748150075765E-13
     -1.16818528500351E-22  -6.21871846417212E-11  -6.23119327919138E-11  -3.87471342555259E-18
      1.21412808016913E-06
      0.00000000000000E+00  -5.85969423384021E-14   0.00000000000000E+00   3.73348827700913E-17   7.48861194471833E-23
      5.86196237526599E-11   5.86196610876176E-11  -1.31533858703916E-18  -4.67849472220128E-03  -4.67849472220731E-03
      0.00000000000000E+00   0.00000000000000E+00   6.02768732101660E-12   0.00000000000000E+00   6.02768732101660E-12
      5.22088834665241E-18  -2.68402454218309E-01  -2.68382087887772E-01   0.00000000000000E+00  -1.20273411511366E-13
     -1.18302077490927E-22  -6.45270749970045E-11  -6.46473484086342E-11  -3.90554975961325E-18
      1.21912808016913E-06
      0.00000000000000E+00  -6.14441291918354E-14   0.00000000000000E+00   3.96912852504495E-17   7.99050051909902E-23
      6.14583364277545E-11   6.14583761191196E-11  -1.31447563059754E-18  -4.43628640781453E-03  -4.43628640782018E-03
      0.00000000000000E+00   0.00000000000000E+00   5.64883088964772E-12   0.00000000000000E+00   5.64883088964772E-12
      5.24913250110065E-18  -2.83650706205103E-01  -2.83629565042682E-01   0.00000000000000E+00  -1.15886159463241E-13
     -1.19709943382794E-22  -6.69913208491846E-11  -6.71072070087675E-11  -3.93465687050311E-18
      1.22412808016913E-06
      0.00000000000000E+00  -6.43831607824763E-14   0.00000000000000E+00   4.18463222327412E-17   8.36189384697613E-23
      6.43663926505092E-11   6.43664344969151E-11  -1.31346725705816E-18  -4.28408271855211E-03  -4.28408271855741E-03
      0.00000000000000E+00   0.00000000000000E+00   5.30626751865208E-12   0.00000000000000E+00   5.30626751865208E-12
      5.27566383869391E-18  -2.98153153992570E-01  -2.98131204722890E-01   0.00000000000000E+00  -1.11744195786466E-13
     -1.21050647913464E-22  -6.95609578196593E-11  -6.96727020155668E-11  -3.96219658163575E-18
      1.22912808016913E-06
      0.00000000000000E+00  -6.74140371103246E-14   0.00000000000000E+00   4.52693245808362E-17   8.66198743196322E-23
      6.73739987197941E-11   6.73740439892053E-11  -1.31230377588973E-18  -4.22374090645449E-03  -4.22374090645947E-03
      0.00000000000000E+00   0.00000000000000E+00   4.98573865417037E-12   0.00000000000000E+00   4.98573865417037E-12
      5.30059253196476E-18  -3.11972278171357E-01  -3.11949482494672E-01   0.00000000000000E+00  -1.07997163183704E-13
     -1.22331982715225E-22  -7.22517854800699E-11  -7.23597826433759E-11  -3.98828875607503E-18
      1.23412808016913E-06
      0.00000000000000E+00  -7.05367581753806E-14   0.00000000000000E+00   4.98060446195180E-17   8.92661214080868E-23
      7.05487851604372E-11   7.05488349665711E-11  -1.31093682973658E-18  -4.27371487301446E-03  -4.27371487301913E-03
      0.00000000000000E+00   0.00000000000000E+00   4.67242013931079E-12   0.00000000000000E+00   4.67242013931079E-12
      5.32395463266131E-18  -3.25179765897536E-01  -3.25156068878501E-01   0.00000000000000E+00  -1.04634020606649E-13
     -1.23560232659340E-22  -7.51166210851516E-11  -7.52212551058818E-11  -4.01301780292473E-18
      1.23912808016913E-06
      0.00000000000000E+00  -7.40268581892666E-14   0.00000000000000E+00   5.74300383430360E-17   9.17956312531854E-23
      7.40237380100972E-11   7.40237954402274E-11  -1.30925014770030E-18  -4.48407831991975E-03  -4.48407831992407E-03
      0.00000000000000E+00   0.00000000000000E+00   4.31855444780955E-12   0.00000000000000E+00   4.31855444780955E-12
      5.34554740490036E-18  -3.37787670890549E-01  -3.37762990744947E-01   0.00000000000000E+00  -1.00839012024670E-13
     -1.24731571827215E-22  -7.82415108758876E-11  -7.83423498880370E-11  -4.03629725720006E-18
      1.24412808016913E-06
      0.00000000000000E+00  -7.81598713636053E-14   0.00000000000000E+00   5.67029568367288E-17   9.44696904721231E-23
      7.81285929337554E-11   7.81286496368067E-11  -1.30695878853297E-18  -4.97856472286871E-03  -4.97856472287257E-03
      0.00000000000000E+00   0.00000000000000E+00   3.85861299082254E-12   0.00000000000000E+00   3.85861299082254E-12
      5.36484046985448E-18  -3.49797419588517E-01  -3.49771591299051E-01   0.00000000000000E+00  -9.57891759843628E-14
     -1.25833027878035E-22  -8.18914734515193E-11  -8.19872626276295E-11  -4.05788168132151E-18
      1.24912808016913E-06
      0.00000000000000E+00  -8.37624003332644E-14   0.00000000000000E+00   1.07520865784458E-16   9.77985745656514E-23
      8.37537930586999E-11   8.37539005796635E-11  -1.30333269436301E-18  -6.07318164799096E-03  -6.07318164799409E-03
      0.00000000000000E+00   0.00000000000000E+00   3.13625169095594E-12   0.00000000000000E+00   3.13625169095594E-12
      5.38052172830925E-18  -3.61220340391055E-01  -3.61192967677537E-01   0.00000000000000E+00  -8.77964158155613E-14
     -1.26831879319638E-22  -8.68023558546768E-11  -8.68901522706192E-11  -4.07718903394624E-18
      1.25412808016913E-06
      0.00000000000000E+00  -9.34979424772622E-14   0.00000000000000E+00   1.99707573220557E-16   1.03053441804921E-22
      9.34708490851358E-11   9.34710487928121E-11  -1.29644635445079E-18  -8.59755222698169E-03  -8.59755222698341E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72092718256410E-12   0.00000000000000E+00   1.72092718256410E-12
      5.38912636422208E-18  -3.72064377750947E-01  -3.72034389866538E-01   0.00000000000000E+00  -7.16875730258748E-14
     -1.27637782091046E-22  -9.51202884022226E-11  -9.51919759753761E-11  -4.09268000977128E-18
      1.25912808016913E-06
      0.00000000000000E+00  -1.14714076772201E-13   0.00000000000000E+00   4.22993283315021E-16   1.13089616254226E-22
      1.14756525334058E-10   1.14756948327454E-10  -1.28166064651892E-18  -1.45199838278111E-02  -1.45199838278098E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.37893936709073E-12   0.00000000000000E+00  -1.37893936709073E-12
      5.38223166738662E-18  -3.82308903568273E-01  -3.82273186746449E-01   0.00000000000000E+00  -3.62178205229098E-14
     -1.28034703868970E-22  -1.13341791139713E-10  -1.13378008960363E-10  -4.10057102086770E-18
      1.26412808016913E-06
      0.00000000000000E+00  -1.66698198031661E-13   0.00000000000000E+00   9.14380624490425E-16   1.31123540502422E-22
      1.66686509206214E-10   1.66687423586969E-10  -1.25150457152980E-18  -2.68711071545821E-02  -2.68711071545748E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.27831495402693E-12   0.00000000000000E+00  -7.27831495402693E-12
      5.34584009261649E-18  -3.91850143804967E-01  -3.91799926127422E-01   0.00000000000000E+00   2.76173210982590E-14
     -1.27704428498728E-22  -1.59436725953913E-10  -1.59409108632942E-10  -4.09433552108668E-18
      1.26912808016913E-06
      0.00000000000000E+00  -2.84534995868918E-13   0.00000000000000E+00   1.77502524293704E-15   1.53465841916808E-22
      2.84489851191117E-10   2.84491626216514E-10  -1.20357772077341E-18  -4.63448538836272E-02  -4.63448538836127E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.45206292815022E-11   0.00000000000000E+00  -1.45206292815022E-11
      5.27323694620898E-18  -4.00416154827806E-01  -4.00331107270401E-01   0.00000000000000E+00   9.27248989555474E-14
     -1.26628135754425E-22  -2.70063721833841E-10  -2.69970996935012E-10  -4.06965922543557E-18
      1.27412808016913E-06
      0.00000000000000E+00  -5.16718491529546E-13   0.00000000000000E+00   2.91876127314167E-15   1.71786084197654E-22
      5.16751179183885E-10   5.16754097945330E-10  -1.14605657670995E-18  -6.96579273797942E-02  -6.96579273797743E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.98839347226542E-11   0.00000000000000E+00  -1.98839347226542E-11
      5.17381727259570E-18  -4.07503248493355E-01  -4.07346721176702E-01   0.00000000000000E+00   1.22823284908200E-13
     -1.25192275435997E-22  -4.96992986507458E-10  -4.96870163222675E-10  -4.02776069588575E-18
      1.27912808016913E-06
      0.00000000000000E+00  -9.23866211570512E-13   0.00000000000000E+00   4.59728519630455E-15   1.84950818872884E-22
      9.23842834268178E-10   9.23847431553559E-10  -1.08825550729752E-18  -9.37371538254383E-02  -9.37371538254151E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.32059238523657E-11   0.00000000000000E+00  -2.32059238523657E-11
      5.05778765333388E-18  -4.12345695878998E-01  -4.12061968117054E-01   0.00000000000000E+00   1.29488045255757E-13
     -1.23649701334665E-22  -9.00770995746324E-10  -9.00641507701192E-10  -3.96953214603636E-18
      1.28412808016913E-06
      0.00000000000000E+00  -1.56760597465807E-12   0.00000000000000E+00   6.86340185109286E-15   1.95054529072399E-22
      1.56761990978983E-09   1.56762677319188E-09  -1.03498889779630E-18  -1.17220399627138E-01  -1.17220399627112E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.58347674651427E-11   0.00000000000000E+00  -2.58347674651427E-11
      4.92861381600816E-18  -4.13928086262110E-01  -4.13442374811603E-01   0.00000000000000E+00   1.33486120224316E-13
     -1.22018424836289E-22  -1.54192549184684E-09  -1.54179200572674E-09  -3.89362491821186E-18
      1.28912808016913E-06
      0.00000000000000E+00  -2.49597257835175E-12   0.00000000000000E+00   9.60446099768107E-15   2.02940964905390E-22
      2.49595707012290E-09   2.49596667458410E-09  -9.87368321733285E-19  -1.39740013001144E-01  -1.39740013001115E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.85850267699554E-11   0.00000000000000E+00  -2.85850267699554E-11
      4.78568868215839E-18  -4.11060184482412E-01  -4.10282878999639E-01   0.00000000000000E+00   1.44381661978305E-13
     -1.20203570159516E-22  -2.46752602947600E-09  -2.46738164781414E-09  -3.79832036042510E-18
      1.29412808016913E-06
      0.00000000000000E+00  -3.72761050430468E-12   0.00000000000000E+00   1.25387027340498E-14   2.08189903576946E-22
      3.72760367196746E-09   3.72761621067040E-09  -9.44928211337083E-19  -1.61225820188964E-01  -1.61225820188933E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.14754241743590E-11   0.00000000000000E+00  -3.14754241743590E-11
      4.62831156128659E-18  -4.02518226898417E-01  -4.01353813695584E-01   0.00000000000000E+00   1.64786718463539E-13
     -1.18071616241511E-22  -3.69630557321439E-09  -3.69614078649604E-09  -3.68338334994951E-18
      1.29912808016913E-06
      0.00000000000000E+00  -5.25048809194268E-12   0.00000000000000E+00   1.53631713238026E-14   2.10116968395441E-22
      5.25044981971126E-09   5.25046518288280E-09  -9.06763078544832E-19  -1.81687327818651E-01  -1.81687327818617E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.42224226998363E-11   0.00000000000000E+00  -3.42224226998363E-11
      4.45719944778741E-18  -3.87190127000887E-01  -3.85546814386818E-01   0.00000000000000E+00   1.94845078643731E-13
     -1.15472189719672E-22  -5.21643760526149E-09  -5.21624276018296E-09  -3.55043636924258E-18
      1.30412808016913E-06
      0.00000000000000E+00  -7.03043909902455E-12   0.00000000000000E+00   1.78611486330224E-14   2.08430569804820E-22
      7.03043560666964E-09   7.03045346781849E-09  -8.71981217768265E-19  -2.01161414208569E-01  -2.01161414208533E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.65582906244950E-11   0.00000000000000E+00  -3.65582906244950E-11
      4.27440799466493E-18  -3.64174658739078E-01  -3.61971295871230E-01   0.00000000000000E+00   2.32499437004018E-13
     -1.12251948789109E-22  -6.99412767663087E-09  -6.99389517719398E-09  -3.40242677689667E-18
      1.30912808016913E-06
      0.00000000000000E+00  -9.01869397009309E-12   0.00000000000000E+00   1.98849118304393E-14   2.03644682306118E-22
      9.01864971975446E-09   9.01866960466649E-09  -8.39851412941954E-19  -2.19692740007108E-01  -2.19692740007070E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.83486808628514E-11   0.00000000000000E+00  -3.83486808628514E-11
      4.08266459035068E-18  -3.32847410299983E-01  -3.30018207279423E-01   0.00000000000000E+00   2.72335115867793E-13
     -1.08263994579145E-22  -8.98059325891940E-09  -8.98032092380364E-09  -3.24281317740872E-18
      1.31412808016913E-06
      0.00000000000000E+00  -1.11419606048567E-11   0.00000000000000E+00   2.11941083727943E-14   1.96928310247445E-22
      1.11419992152806E-08   1.11420204093892E-08  -8.09842876698233E-19  -2.37326092888050E-01  -2.37326092888010E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.96959885237952E-11   0.00000000000000E+00  -3.96959885237952E-11
      3.88418464773170E-18  -2.92973149301671E-01  -2.89475371077598E-01   0.00000000000000E+00   3.02698828760895E-13
     -1.03353302316723E-22  -1.11026271196940E-08  -1.11023244208654E-08  -3.07434177103347E-18
      1.31912808016913E-06
      0.00000000000000E+00  -1.32510831500903E-11   0.00000000000000E+00   2.10328198967633E-14   1.88050654638858E-22
      1.32510395082280E-08   1.32510605410480E-08  -7.81685987620031E-19  -2.54102339469713E-01  -2.54102339469672E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.11749457761618E-11   0.00000000000000E+00  -4.11749457761618E-11
      3.67830991885089E-18  -2.45044312351969E-01  -2.40882487568768E-01   0.00000000000000E+00   3.04182587302047E-13
     -9.73723154228682E-23  -1.32101897778591E-08  -1.32098855952719E-08  -2.89662393123086E-18
      1.32412808016913E-06
      0.00000000000000E+00  -1.50454537809138E-11   0.00000000000000E+00   1.79086309738656E-14   1.70861040192569E-22
      1.50454200712393E-08   1.50454379798705E-08  -7.55428070629728E-19  -2.70055706754773E-01  -2.70055706754729E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.38666954130525E-11   0.00000000000000E+00  -4.38666954130525E-11
      3.45897644178563E-18  -1.90924994172911E-01  -1.86198630518278E-01   0.00000000000000E+00   2.62093237531594E-13
     -9.07256140064627E-23  -1.50018333776949E-08  -1.50015712844574E-08  -2.70354837115590E-18
      1.32912808016913E-06
      0.00000000000000E+00  -1.62497219751789E-11   0.00000000000000E+00   1.80850885001984E-14   1.38850142790056E-22
      1.62497187075352E-08   1.62497367926238E-08  -7.31019945002938E-19  -2.85222701209866E-01  -2.85222701209819E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.69998134542698E-11   0.00000000000000E+00  -4.69998134542698E-11
      3.22397737451428E-18  -1.33665645410503E-01  -1.28560796281020E-01   0.00000000000000E+00   1.94519754518852E-13
     -8.49896513876806E-23  -1.62029314989240E-08  -1.62027369791696E-08  -2.49295742951134E-18
      1.33412808016913E-06
      0.00000000000000E+00  -1.64209205653337E-11   0.00000000000000E+00   2.05309137656519E-13   9.28496099643370E-23
      1.64209378711077E-08   1.64211431802454E-08  -7.08185265234223E-19  -2.99649000533703E-01  -2.99649000533655E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.82991464117109E-11   0.00000000000000E+00  -4.82991464117109E-11
      2.98248164245573E-18  -7.82750349240414E-02  -7.31166157260503E-02   0.00000000000000E+00  -5.20532485554992E-14
     -7.43070365280289E-23  -1.63727919805851E-08  -1.63728440338337E-08  -2.27429637722150E-18
      1.33912808016913E-06
      0.00000000000000E+00  -1.37867216574846E-11   0.00000000000000E+00  -2.58498756490117E-14   4.47780903330272E-23
      1.37867975832787E-08   1.37867717334030E-08  -6.85311574015800E-19  -3.13400794927372E-01  -3.13400794927329E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.29791899659161E-11   0.00000000000000E+00  -4.29791899659161E-11
      2.76758569262615E-18  -3.79360371136475E-02  -3.36058504945922E-02   0.00000000000000E+00   1.19643292093947E-13
     -4.33773266258102E-23  -1.37439121867292E-08  -1.37437925434371E-08  -2.08227411861035E-18
      1.34412808016913E-06
      0.00000000000000E+00  -9.73609321242108E-12   0.00000000000000E+00  -3.98078182111286E-14   2.01086295045174E-23
      9.73607798696745E-09   9.73603817914926E-09  -6.59568398433029E-19  -3.26544855406991E-01  -3.26544855406960E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.02020488648394E-11   0.00000000000000E+00  -3.02020488648394E-11
      2.61657544830195E-18  -1.86345039233646E-02  -1.55765280503371E-02   0.00000000000000E+00   8.63258079334538E-14
     -2.01887602803285E-23  -9.70592245609232E-09  -9.70583613028441E-09  -1.95700704986892E-18
      1.34912808016913E-06
      0.00000000000000E+00  -7.40902310579398E-12   0.00000000000000E+00  -2.27941998854593E-14   1.10869993398687E-23
      7.40900852322709E-09   7.40898572902722E-09  -6.32124784972564E-19  -3.39089064024719E-01  -3.39089064024697E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.15710678431953E-11   0.00000000000000E+00  -2.15710678431953E-11
      2.50872010908597E-18  -1.12268489599142E-02  -8.89932482975967E-03   0.00000000000000E+00   4.86458963512424E-14
     -1.12694678106111E-23  -7.38746330708036E-09  -7.38741466118402E-09  -1.87659532411341E-18
      1.35412808016913E-06
      0.00000000000000E+00  -6.53062003914119E-12   0.00000000000000E+00  -8.51551292841926E-15   7.31590192713891E-24
      6.53063457663819E-09   6.53062606112527E-09  -6.04557624922080E-19  -3.51035979087365E-01  -3.51035979087347E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.78301241025290E-11   0.00000000000000E+00  -1.78301241025290E-11
      2.41956948857333E-18  -8.30707050912147E-03  -6.25510703858459E-03   0.00000000000000E+00   2.67788938640034E-14
     -8.31784012123998E-24  -6.51282271591660E-09  -6.51279593702274E-09  -1.81501186365125E-18
      1.35912808016913E-06
      0.00000000000000E+00  -6.24112542746307E-12   0.00000000000000E+00  -2.72156474591060E-15   5.56690807747230E-24
      6.24108648095045E-09   6.24108375938571E-09  -5.77557758201450E-19  -3.62397386726239E-01  -3.62397386726223E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.61966806674016E-11   0.00000000000000E+00  -1.61966806674016E-11
      2.33858608523632E-18  -6.88409742702397E-03  -4.92284274441710E-03   0.00000000000000E+00   1.76954289963144E-14
     -6.62980375728071E-24  -6.22490477414731E-09  -6.22488707871832E-09  -1.76102832703487E-18
      1.36412808016913E-06
      0.00000000000000E+00  -6.13734087441856E-12   0.00000000000000E+00  -9.01762043586477E-16   4.50041263476176E-24
      6.13735947938605E-09   6.13735857762401E-09  -5.51436523250765E-19  -3.73179697782350E-01  -3.73179697782334E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.52740195628839E-11   0.00000000000000E+00  -1.52740195628839E-11
      2.26221598742190E-18  -6.01185407651521E-03  -4.08298764864308E-03   0.00000000000000E+00   1.38731989698542E-14
     -5.53117868207775E-24  -6.12209843126010E-09  -6.12208455806113E-09  -1.71077946417114E-18
      1.36912808016913E-06
      0.00000000000000E+00  -6.08912238738461E-12   0.00000000000000E+00  -3.66914684099105E-16   3.76909235442345E-24
      6.08910120697761E-09   6.08910084006293E-09  -5.26457198396524E-19  -3.83356792709697E-01  -3.83356792709682E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.45521387580482E-11   0.00000000000000E+00  -1.45521387580482E-11
      2.18945529363166E-18  -5.40366861609746E-03  -3.48977794452388E-03   0.00000000000000E+00   1.17566673679283E-14
     -4.73518578651806E-24  -6.07456045797225E-09  -6.07454870130489E-09  -1.66299809523514E-18
      1.37412808016913E-06
      0.00000000000000E+00  -6.05945653726658E-12   0.00000000000000E+00  -1.95135421217821E-16   3.24443246522732E-24
      6.05948517054213E-09   6.05948497540671E-09  -5.03055870763828E-19  -3.92811196662858E-01  -3.92811196662844E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37418911677127E-11   0.00000000000000E+00  -1.37418911677127E-11
      2.12074583779310E-18  -4.95898452310242E-03  -3.05416849788563E-03   0.00000000000000E+00   1.01217875134852E-14
     -4.14008551375424E-24  -6.04575320602651E-09  -6.04574308423900E-09  -1.61768996702927E-18
      1.37912808016913E-06
      0.00000000000000E+00  -6.03723011086236E-12   0.00000000000000E+00  -1.32942304007344E-16   2.86510013976642E-24
      6.03718987953732E-09   6.03718974659502E-09  -4.82072665464418E-19  -4.01248723099771E-01  -4.01248723099759E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25010845984919E-11   0.00000000000000E+00  -1.25010845984919E-11
      2.05824041480064E-18  -4.63367737418220E-03  -2.73549402141300E-03   0.00000000000000E+00   8.50042538309661E-15
     -3.70301251543390E-24  -6.02469716242191E-09  -6.02468866199653E-09  -1.57616774933622E-18
      1.38412808016913E-06
      0.00000000000000E+00  -6.01739164762553E-12   0.00000000000000E+00  -1.30092150821331E-16   2.59873429357448E-24
      6.01743518484569E-09   6.01743505475354E-09  -4.64903434874538E-19  -4.08138811276655E-01  -4.08138811276645E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04012064933265E-11   0.00000000000000E+00  -1.04012064933265E-11
      2.00623438233400E-18  -4.40616259227070E-03  -2.51354100264777E-03   0.00000000000000E+00   6.63561189621422E-15
     -3.40551691140831E-24  -6.00704048387210E-09  -6.00703384826021E-09  -1.54133094745946E-18
      1.38912808016913E-06
      0.00000000000000E+00  -5.99718580543987E-12   0.00000000000000E+00  -1.58468318893884E-16   2.42958289608097E-24
      5.99715703733687E-09   5.99715687886855E-09  -4.53563898391806E-19  -4.12687717379819E-01  -4.12687717379812E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.97226103244301E-12   0.00000000000000E+00  -6.97226103244301E-12
      1.97137307717179E-18  -4.26810374618296E-03  -2.38079036522363E-03   0.00000000000000E+00   4.28740307875389E-15
     -3.24635119999063E-24  -5.99018890523918E-09  -5.99018461783611E-09  -1.51780917877998E-18
      1.39412808016913E-06
      0.00000000000000E+00  -5.97339801850312E-12   0.00000000000000E+00  -2.23366916397882E-16   2.35458884171276E-24
      5.97343230832104E-09   5.97343208495413E-09  -4.50650031570641E-19  -4.13856644035072E-01  -4.13856644035070E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.81226638117733E-12   0.00000000000000E+00  -1.81226638117733E-12
      1.96231174526590E-18  -4.22351119796265E-03  -2.34204687094845E-03   0.00000000000000E+00   1.22980996479305E-15
     -3.24593800371179E-24  -5.97162104838290E-09  -5.97161981857294E-09  -1.51166171369526E-18
      1.39912808016913E-06
      0.00000000000000E+00  -5.94226265258977E-12   0.00000000000000E+00  -3.38167722871527E-16   2.38473478069075E-24
      5.94225156781332E-09   5.94225122964560E-09  -4.59155346079688E-19  -4.10444355486180E-01  -4.10444355486186E-01
      0.00000000000000E+00   0.00000000000000E+00   5.23574887140594E-12   0.00000000000000E+00   5.23574887140594E-12
      1.98849048962293E-18  -4.29445464567346E-03  -2.42059410914806E-03   0.00000000000000E+00  -2.80446434242898E-15
     -3.46455986799044E-24  -5.94748417405267E-09  -5.94748697851701E-09  -1.52933514354324E-18
      1.40412808016913E-06
      0.00000000000000E+00  -5.89606474977439E-12   0.00000000000000E+00  -5.41059810696977E-16   2.55220863691238E-24
      5.89608927805345E-09   5.89608873699364E-09  -4.82116049378480E-19  -4.01232657396380E-01  -4.01232657396394E-01
      0.00000000000000E+00   0.00000000000000E+00   1.39111009526503E-11   0.00000000000000E+00   1.39111009526503E-11
      2.05804599438618E-18  -4.53879017547186E-03  -2.67674151252736E-03   0.00000000000000E+00  -8.17546660136937E-15
     -4.05352648583050E-24  -5.90999166247968E-09  -5.90999983794628E-09  -1.57592994500770E-18
      1.40912808016913E-06
      0.00000000000000E+00  -5.81698643103871E-12   0.00000000000000E+00  -9.39896212674059E-16   2.92654165345919E-24
      5.81701968313653E-09   5.81701874324032E-09  -5.22113393641196E-19  -3.85128012764967E-01  -3.85128012764990E-01
      0.00000000000000E+00   0.00000000000000E+00   2.35731791834921E-11   0.00000000000000E+00   2.35731791834921E-11
      2.17591189030364E-18  -5.09968531980947E-03  -3.25950649647034E-03   0.00000000000000E+00  -1.54594650015452E-14
     -5.40509045511331E-24  -5.84057646295881E-09  -5.84059192242382E-09  -1.65379849666245E-18
      1.41412808016913E-06
      0.00000000000000E+00  -5.65671736461157E-12   0.00000000000000E+00  -1.13767640791773E-15   3.63952701350520E-24
      5.65673576530501E-09   5.65673462762860E-09  -5.80461208248897E-19  -3.61255532658100E-01  -3.61255532658134E-01
      0.00000000000000E+00   0.00000000000000E+00   3.36327189870632E-11   0.00000000000000E+00   3.36327189870632E-11
      2.34407548523896E-18  -6.34545477289189E-03  -4.55260971973654E-03   0.00000000000000E+00  -2.62922397982626E-14
     -8.59582042431951E-24  -5.69034105437586E-09  -5.69036734661567E-09  -1.76361427699006E-18
      1.41912808016913E-06
      0.00000000000000E+00  -5.28548093681875E-12   0.00000000000000E+00  -4.05780226867619E-15   4.87251743390825E-24
      5.28551565473323E-09   5.28551159693097E-09  -6.55849839668472E-19  -3.29024699344020E-01  -3.29024699344064E-01
      0.00000000000000E+00   0.00000000000000E+00   4.46166411071631E-11   0.00000000000000E+00   4.46166411071631E-11
      2.56715869077478E-18  -9.23970576674294E-03  -7.56036384583949E-03   0.00000000000000E+00  -3.98408983491102E-14
     -1.64798988975804E-23  -5.33008839713977E-09  -5.33012823803814E-09  -1.91130885110630E-18
      1.42412808016913E-06
      0.00000000000000E+00  -4.43095750183992E-12   0.00000000000000E+00  -8.29423308796233E-15   6.48990887448128E-24
      4.43095521035539E-09   4.43094691612231E-09  -7.43621168787159E-19  -2.88255126674783E-01  -2.88255126674842E-01
      0.00000000000000E+00   0.00000000000000E+00   5.89439008282898E-11   0.00000000000000E+00   5.89439008282898E-11
      2.86187819491623E-18  -1.59806327625151E-02  -1.45660263796864E-02   0.00000000000000E+00  -6.06058572792793E-14
     -3.42562361843479E-23  -4.48983021109328E-09  -4.48989081695060E-09  -2.11825702612906E-18
      1.42912808016913E-06
      0.00000000000000E+00  -2.90651855366939E-12   0.00000000000000E+00  -1.57777462744289E-14   6.10275234212821E-24
      2.90649505896989E-09   2.90647928122362E-09  -8.39268478291384E-19  -2.39552842852816E-01  -2.39552842852893E-01
      0.00000000000000E+00   0.00000000000000E+00   7.63191092824326E-11   0.00000000000000E+00   7.63191092824326E-11
      3.24347374132839E-18  -2.95471064672805E-02  -2.86073366176463E-02   0.00000000000000E+00  -9.02026117963163E-14
     -6.14665569749153E-23  -2.98270818789420E-09  -2.98279839050606E-09  -2.40420526303700E-18
      1.43412808016913E-06
      0.00000000000000E+00  -1.32816674475804E-12   0.00000000000000E+00  -1.65027987084649E-14  -2.26566445029015E-24
      1.32816497275778E-09   1.32814846995907E-09  -9.43015487995925E-19  -1.84945946541173E-01  -1.84945946541261E-01
      0.00000000000000E+00   0.00000000000000E+00   8.75853642909657E-11   0.00000000000000E+00   8.75853642909657E-11
      3.68140056278322E-18  -4.98959151444858E-02  -4.94498727973489E-02   0.00000000000000E+00  -1.38694292491453E-13
     -8.21118878132872E-23  -1.41559513995746E-09  -1.41573383425004E-09  -2.73838507478729E-18
      1.43912808016913E-06
      0.00000000000000E+00  -4.39109688589185E-13   0.00000000000000E+00  -9.82950676027013E-15  -1.79219572361590E-23
      4.39095546841464E-10   4.39085717334686E-10  -1.05654043477466E-18  -1.27567021168923E-01  -1.27567021169010E-01
      0.00000000000000E+00   0.00000000000000E+00   8.69271588010476E-11   0.00000000000000E+00   8.69271588010476E-11
      4.11603635678846E-18  -7.34888344541064E-02  -7.33231098445564E-02   0.00000000000000E+00  -2.05923579991719E-13
     -9.09997527361295E-23  -5.25806952555651E-10  -5.26012876135733E-10  -3.05949592201379E-18
      1.44412808016913E-06
      0.00000000000000E+00  -1.17744953100049E-13   0.00000000000000E+00  -4.46872426140082E-15  -3.12315020135067E-23
      1.17833163488977E-10   1.17828694764684E-10  -1.17142069550309E-18  -7.29922680842686E-02  -7.29922680843441E-02
      0.00000000000000E+00   0.00000000000000E+00   7.55030728322187E-11   0.00000000000000E+00   7.55030728322187E-11
      4.49355172094955E-18  -9.75276036640608E-02  -9.74666934013279E-02   0.00000000000000E+00  -2.77267841758874E-13
     -9.70458843268217E-23  -1.93054499755047E-10  -1.93331767596902E-10  -3.32213102544645E-18
      1.44912808016913E-06
      0.00000000000000E+00  -4.40854738596128E-14   0.00000000000000E+00  -1.74842610041670E-15  -3.50667145547142E-23
      4.41253271346493E-11   4.41235787085138E-11  -1.25452504764336E-18  -3.50024140349805E-02  -3.50024140350331E-02
      0.00000000000000E+00   0.00000000000000E+00   5.26046375175814E-11   0.00000000000000E+00   5.26046375175814E-11
      4.75657490853746E-18  -1.20869220049892E-01  -1.20838745457063E-01   0.00000000000000E+00  -2.76664612303243E-13
     -1.02275791743021E-22  -9.64515516136898E-11  -9.67282162260953E-11  -3.50204986089410E-18
      1.45412808016913E-06
      0.00000000000000E+00  -3.73808080434634E-14   0.00000000000000E+00  -5.00931014053470E-16  -3.02381120537219E-23
      3.74092724176645E-11   3.74087714866202E-11  -1.29429095114261E-18  -1.74606157646531E-02  -1.74606157646830E-02
      0.00000000000000E+00   0.00000000000000E+00   2.99288112692571E-11   0.00000000000000E+00   2.99288112692571E-11
      4.90621896488374E-18  -1.43226023975175E-01  -1.43204809186411E-01   0.00000000000000E+00  -2.07512138598116E-13
     -1.05779794944762E-22  -6.71300706171734E-11  -6.73375827558773E-11  -3.61192801374113E-18
      1.45912808016913E-06
      0.00000000000000E+00  -4.11464422689720E-14   0.00000000000000E+00  -7.92533276724787E-17  -1.70046373966463E-23
      4.11335093909844E-11   4.11334301376398E-11  -1.30943792893351E-18  -1.07848514031181E-02  -1.07848514031354E-02
      0.00000000000000E+00   0.00000000000000E+00   1.72207018258002E-11   0.00000000000000E+00   1.72207018258002E-11
      4.99232247401274E-18  -1.64547242136455E-01  -1.64528857752084E-01   0.00000000000000E+00  -1.61006614008688E-13
     -1.08277158739180E-22  -5.81931253493230E-11  -5.83541319634400E-11  -3.68288454507923E-18
      1.46412808016913E-06
      0.00000000000000E+00  -4.50039212316881E-14   0.00000000000000E+00   9.29065846338410E-18   3.75049459365913E-24
      4.50441330569293E-11   4.50441423475916E-11  -1.31465776747517E-18  -8.11167375390907E-03  -8.11167375392057E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15036625543188E-11   0.00000000000000E+00   1.15036625543188E-11
      5.04984078678433E-18  -1.84848923011446E-01  -1.84831107833790E-01   0.00000000000000E+00  -1.43325122684292E-13
     -1.10371273555315E-22  -5.64044797791153E-11  -5.65478049019100E-11  -3.73518301930916E-18
      1.46912808016913E-06
      0.00000000000000E+00  -4.82184870339515E-14   0.00000000000000E+00   3.25494284708841E-17   2.63848521611882E-23
      4.82518042429214E-11   4.82518367923763E-11  -1.31631403611081E-18  -6.77336705356728E-03  -6.77336705357622E-03
      0.00000000000000E+00   0.00000000000000E+00   8.94225510229237E-12   0.00000000000000E+00   8.94225510229237E-12
      5.09455206229580E-18  -2.04170048196669E-01  -2.04152029527253E-01   0.00000000000000E+00  -1.36637991508982E-13
     -1.12270150523845E-22  -5.70574539030478E-11  -5.71940918946690E-11  -3.77823802618498E-18
      1.47412808016913E-06
      0.00000000000000E+00  -5.10656738873849E-14   0.00000000000000E+00   3.28787822279197E-17   4.57542551008760E-23
      5.10893401814202E-11   5.10893730602481E-11  -1.31664989306151E-18  -5.93742082954909E-03  -5.93742082955674E-03
      0.00000000000000E+00   0.00000000000000E+00   7.64992108697277E-12   0.00000000000000E+00   7.64992108697277E-12
      5.13280166773066E-18  -2.22555644411900E-01  -2.22537139047442E-01   0.00000000000000E+00  -1.32275453215285E-13
     -1.14029838400072E-22  -5.86070186938916E-11  -5.87392941472209E-11  -3.81615177466915E-18
      1.47912808016913E-06
      0.00000000000000E+00  -5.38210160036107E-14   0.00000000000000E+00   3.36950345590610E-17   6.00689036027476E-23
      5.38234623466656E-11   5.38234960417602E-11  -1.31641357703522E-18  -5.34982783414606E-03  -5.34982783415294E-03
      0.00000000000000E+00   0.00000000000000E+00   6.88099050503086E-12   0.00000000000000E+00   6.88099050503086E-12
      5.16720662025582E-18  -2.40050125984859E-01  -2.40031001614109E-01   0.00000000000000E+00  -1.27996775155906E-13
     -1.15673593477765E-22  -6.05764897715196E-11  -6.07044865467911E-11  -3.85079304322059E-18
      1.48412808016913E-06
      0.00000000000000E+00  -5.65763581198365E-14   0.00000000000000E+00   3.56483649323018E-17   6.98289925319635E-23
      5.65703486626399E-11   5.65703843110747E-11  -1.31586992040438E-18  -4.91935338981371E-03  -4.91935338982006E-03
      0.00000000000000E+00   0.00000000000000E+00   6.34607964540832E-12   0.00000000000000E+00   6.34607964540832E-12
      5.19893701848286E-18  -2.56693387861641E-01  -2.56673566742451E-01   0.00000000000000E+00  -1.23564063815458E-13
     -1.17219644938413E-22  -6.27928998925504E-11  -6.29164639564831E-11  -3.88306709807848E-18
      1.48912808016913E-06
      0.00000000000000E+00  -5.93317002360623E-14   0.00000000000000E+00   3.79555080517870E-17   7.63895861182219E-23
      5.93660002778411E-11   5.93660382334255E-11  -1.31512464647561E-18  -4.60516756459020E-03  -4.60516756459612E-03
      0.00000000000000E+00   0.00000000000000E+00   5.92236930967924E-12   0.00000000000000E+00   5.92236930967924E-12
      5.22854886503125E-18  -2.72518942554798E-01  -2.72498374296854E-01   0.00000000000000E+00  -1.19093535193676E-13
     -1.18682181454556E-22  -6.51693140077925E-11  -6.52884075431048E-11  -3.91342421855565E-18
      1.49412808016913E-06
      0.00000000000000E+00  -6.21788870894956E-14   0.00000000000000E+00   4.00675530481700E-17   8.09867495370772E-23
      6.22216022089838E-11   6.22216422766179E-11  -1.31422238048512E-18  -4.38732869701729E-03  -4.38732869702284E-03
      0.00000000000000E+00   0.00000000000000E+00   5.55543621236464E-12   0.00000000000000E+00   5.55543621236464E-12
      5.25632604609308E-18  -2.87565044732660E-01  -2.87543692566927E-01   0.00000000000000E+00  -1.14762244938516E-13
     -1.20071523698627E-22  -6.76623162439242E-11  -6.77770784889828E-11  -3.94210366560796E-18
      1.49912808016913E-06
      0.00000000000000E+00  -6.51179186801365E-14   0.00000000000000E+00   4.29175261128952E-17   8.44657482472465E-23
      6.51516950954174E-11   6.51517380130280E-11  -1.31317522623138E-18  -4.25874614515334E-03  -4.25874614515856E-03
      0.00000000000000E+00   0.00000000000000E+00   5.21925186793541E-12   0.00000000000000E+00   5.21925186793541E-12
      5.28242230543275E-18  -3.01878479006182E-01  -3.01856309782224E-01   0.00000000000000E+00  -1.10698640080580E-13
     -1.21395638054280E-22  -7.02602912407614E-11  -7.03709898809634E-11  -3.96924707920137E-18
      1.50000000000000E-06
      0.00000000000000E+00  -6.56689871033816E-14   0.00000000000000E+00   4.39064207441121E-17   8.50450761102645E-23
      6.56729464791252E-11   6.56729903856310E-11  -1.31298745463726E-18  -4.23946710841882E-03  -4.23946710842398E-03
      0.00000000000000E+00   0.00000000000000E+00   5.15611118778449E-12   0.00000000000000E+00   5.15611118778449E-12
      5.28691802102755E-18  -3.04352105782212E-01  -3.04329792257089E-01   0.00000000000000E+00  -1.11271613890851E-13
     -1.21626326330474E-22  -7.07178299593995E-11  -7.08291015734120E-11  -3.97393056639029E-18
}
